//*****************************************************************************
/*
** FILE:   xg_VerificationException.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    09May98  stevew  Created.
*/
package xg;

//*****************************************************************************
/** An exception which occurred when verifying - ie. calling verify() on - an
 *  xg_Node.
 */
public class xg_VerificationException extends xg_Exception
{
    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID       ID to be used to retrieve message text
     *  @param  InputParameterArray  Array of parameter values
     *  @param  InputStartOffset     Start of area in source to highlight
     *  @param  InputEndOffset       End of area in source to highlight
     */
    public xg_VerificationException(String    InputMessageID,
                                    Object[]  InputParameterArray,
                                    int       InputStartOffset,
                                    int       InputEndOffset)
    {
        super(InputMessageID,
              InputParameterArray,
              InputStartOffset,
              InputEndOffset);
    }

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID       ID to be used to retrieve message text
     *  @param  InputParameterArray  Array of parameter values
     */
    public xg_VerificationException(String    InputMessageID,
                                    Object[]  InputParameterArray)
    {
        super(InputMessageID, InputParameterArray);
    }

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID     ID to be used to retrieve message text
     *  @param  InputStartOffset   Start of area in source to highlight
     *  @param  InputEndOffset     End of area in source to highlight
     */
    public xg_VerificationException(String  InputMessageID,
                                    int     InputStartOffset,
                                    int     InputEndOffset)
    {
        super(InputMessageID, InputStartOffset, InputEndOffset);
    }

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID  ID to be used to retrieve message text
     */
    public xg_VerificationException(String  InputMessageID)
    {
        super(InputMessageID);
    }
}

//*****************************************************************************
