//*****************************************************************************
/*
** FILE:   xg_Value.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    16Nov97  stevew  Created.
*/
package xg;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_Value - Representation of any value within an XML source. All
*  values are Strings, and may be preceded by whitespace (which is recorded
*  as part of the xg_Value).
*/
public class xg_Value
{
    protected String  PrecedingWhitespace = null;
    // If this value was preceded by whitespace in the source, this is it.

    protected String  Value               = null;
    // The value itself.

//    protected char    QuoteChar           = ' ';
    // If the value is quoted, this records the type of quote. If it is not
    // quoted, this should be space.

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xg_Value()
    {
    }

    //*****************************************************************************
    /**
     * Construct a value with a value!
     *
     * @param  InputValue  The actual value
     */
    public xg_Value(String  InputValue)
    {
        Value = InputValue;
    }

    //*****************************************************************************
    /**
     * Save this value (and its preceding whitespace) as an XML source in InputWriter.
     *
     * @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        if (PrecedingWhitespace != null)
            InputWriter.write(PrecedingWhitespace);
//        if (QuoteChar != ' ')
//            InputWriter.write(QuoteChar);
        if (Value != null)
            InputWriter.write(Value);
//        if (QuoteChar != ' ')
//            InputWriter.write(QuoteChar);
    }

    //*****************************************************************************
    /**
     * Get the value of the preceding whitespace.
     *
     * @return  String value or null
     */
    public String getPrecedingWhitespace()
    {
        return PrecedingWhitespace;
    }

    //*****************************************************************************
    /**
     * Get the actual value.
     *
     * @return  The actual value
     */
    public String getValue()
    {
        return Value;
    }

    //*****************************************************************************
    /**
     * Get the quote character.
     *
     * @return  The character used to to quote the Value.
     */
//    public char getQuoteChar()
//    {
//        return QuoteChar;
//    }

    //*****************************************************************************
    /**
     * Set the value of the preceding whitespace.
     *
     * @param  InputPrecedingWhitespace   Value of the preceding whitespace
     */
    public void setPrecedingWhitespace(String  InputPrecedingWhitespace)
    {
        PrecedingWhitespace = InputPrecedingWhitespace;
    }

    //*****************************************************************************
    /**
     * Set the actual value.
     *
     * @param  InputValue   The actual value
     */
    public void setValue(String  InputValue)
    {
        Value = InputValue;
    }

    //*****************************************************************************
    /**
     * Set the quote character.
     *
     * @param  InputQuoteChar   The quote character
     */
//    public void setQuoteChar(char  InputQuoteChar)
//    {
//        QuoteChar = InputQuoteChar;
//    }

    //*****************************************************************************
    /**
     * Return a string representation of the value: the value itself.
     *
     * @return  String representing the value
     */
    public String toString()
    {
        return (Value);
    }
}

//*****************************************************************************
