//*****************************************************************************
/*
** FILE:   xg_ValidationException.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    09May98  stevew  Created.
*/
package xg;

//*****************************************************************************
/**
*  Class xg_ValidationException - An exception which occurred when validating
*  (ie. calling validate() on) an xg_Node.
*/
public class xg_ValidationException extends xg_Exception
{
    //*****************************************************************************
    /**
     * Constructor.
     *
     * @param  InputMessageID       ID to be used to retrieve message text
     * @param  InputParameterArray  Array of parameter values
     * @param  InputStartPosition   Start of area in source to highlight
     * @param  InputEndPosition     End of area in source to highlight
     */
    public xg_ValidationException(String    InputMessageID,
                                  Object[]  InputParameterArray,
                                  int       InputStartPosition,
                                  int       InputEndPosition)
    {
        super(InputMessageID,
              InputParameterArray,
              InputStartPosition,
              InputEndPosition);
    }

    //*****************************************************************************
    /**
     * Constructor.
     *
     * @param  InputMessageID       ID to be used to retrieve message text
     * @param  InputParameterArray  Array of parameter values
     */
    public xg_ValidationException(String    InputMessageID,
                                  Object[]  InputParameterArray)
    {
        super(InputMessageID, InputParameterArray);
    }

    //*****************************************************************************
    /**
     * Constructor.
     *
     * @param  InputMessageID       ID to be used to retrieve message text
     * @param  InputStartPosition   Start of area in source to highlight
     * @param  InputEndPosition     End of area in source to highlight
     */
    public xg_ValidationException(String  InputMessageID,
                                  int     InputStartPosition,
                                  int     InputEndPosition)
    {
        super(InputMessageID,
              InputStartPosition,
              InputEndPosition);
    }

    //*****************************************************************************
    /**
     * Constructor.
     *
     * @param  InputMessageID  ID to be used to retrieve message text
     */
    public xg_ValidationException(String  InputMessageID)
    {
        super(InputMessageID);
    }
}

//*****************************************************************************
