//*****************************************************************************
/*
** FILE:   xg_Text.java
**
** (c) 1997, 1998 Steve Withall.
**
** HISTORY:
**    25Oct97  stevew  Created.
*/
package xg;

import xa.xa_NodeTypeChoiceList;

//import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** A representation of a piece of text within the content of an XML element.
 */
public class xg_Text extends xg_Node
{
    /** The value of the text itself. */
    protected String  TextValue = null;

    //*****************************************************************************
    /** Default constructor.
     */
    public xg_Text()
    {
    }

    //*****************************************************************************
    /** Construct a text with a value.
     *
     *  @param  InputTextValue  The value of the text itself
     */
    public xg_Text(String  InputTextValue)
    {
        TextValue = InputTextValue;
    }

    //*****************************************************************************
    /** Save this text in XML source form in InputWriter.
     *
     *  @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
//        eh_Debug.add(8, "xg_Text.save: Save text '" + TextValue + "'");  //TEMP
        writePrecedingWhitespace(InputWriter);
        InputWriter.write(TextValue);
    }

    //*****************************************************************************
    /** Write this text to InputWriter.
     *
     *  @param  InputWriter   The writer to which the content will be written
     */
    public void writeContent(Writer  InputWriter) throws IOException
    {
//        eh_Debug.add(8, "xg_Text.writeContent:");
        writePrecedingWhitespace(InputWriter);
        InputWriter.write(TextValue);
    }

    //*****************************************************************************
    /** Set the value of this text.
     *
     *  @param  InputTextValue  The value of the text itself
     */
    public void setTextValue(String  InputTextValue)
    {
        TextValue = InputTextValue;
    }

    //*****************************************************************************
    /** Get the type of this node.
     *
     *  @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.TEXT_TYPE;
    }

    //*****************************************************************************
    /** Get the value of the text.
     *
     *  @return  The value of the text
     */
    public String getTextValue()
    {
        return TextValue;
    }

    //*****************************************************************************
    /** Return a string representation of the character data.
     *
     *  @return  A description suitable for display
     */
    public String toString()
    {
        String  SummaryString;
        if (TextValue == null)
            SummaryString = new String("Uninitialised text");
        else if (TextValue.length() > 30)
            SummaryString = new String("Text '" + TextValue.substring(0, 30) + "...'");
        else
            SummaryString = new String("Text '" + TextValue + "'");
        return SummaryString;
    }
}

//*****************************************************************************
