//*****************************************************************************
/*
** FILE:   xg_Reference.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    25Apr98  stevew  Created.
*/
package xg;

import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_Reference - A representation of an entity reference.
*/
public class xg_Reference extends xg_Node
{
    protected String  RawValue       = null;
    // The value of the reference as it exists in the XML source.

    protected String  ProcessedValue = null;
    // The value of the reference after it has been processed.

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xg_Reference()
    {
    }

    //*****************************************************************************
    /**
     * Construct a reference with a value.
     *
     * @param  InputRawValue  The value of the raw value of the reference
     */
    public xg_Reference(String  InputRawValue)
    {
//        super();
        RawValue = InputRawValue;
    }

    //*****************************************************************************
    /**
     * Save this reference in XML source form in InputWriter.
     *
     * @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "xg_Reference.save: Save reference '" + RawValue + "'");  //TEMP

        //TBD Need to out put initial '&', plus possibly '#'/'#x'.
        InputWriter.write(RawValue);
        InputWriter.write(';');
    }

    //*****************************************************************************
    /**
     * Set the value of this text.
     *
     * @param  InputRawValue  The value of the text itself
     */
    public void setValue(String  InputRawValue)
    {
        RawValue = InputRawValue;
        //TBD Need to compute ProcessedValue.
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.REFERENCE_TYPE;
    }

    //*****************************************************************************
    /**
     * Get the type of this node, using only type values defined for the DOM.
     * (Implements org.w3c.dom.Node.getNodeType.)
     *
     * @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return -1;
    }

    //*****************************************************************************
    /**
     * Get a summary descriptive string (intended for display in the tree view).
     *
     * @return  A description suitable for display in the tree view
     */
    public String getSummaryString()
    {
        //TBD Ought to tailor according to reference type
        return("Reference '" + RawValue + "'");
    }

    //*****************************************************************************
    /**
     * Get the value of the text.
     *
     * @return  The value of the text
     */
    public String getRawValue()
    {
        return RawValue;
    }
}

//*****************************************************************************
