//*****************************************************************************
/*
** FILE:   xg_PI.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    18Apr98  stevew  Created.
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** An XML processing instruction.
*/
public class xg_PI extends xg_Node
{
    protected String  InstructionString = null;
    // The value of the instruction itself.

    //*****************************************************************************
    /** Default constructor.
     */
    public xg_PI()
    {
    }

    //*****************************************************************************
    /** Construct a processing instruction with a name.
     *
     *  @param  InputNodeName  The name of the node
     */
    public xg_PI(String InputNodeName)
    {
        NodeName = InputNodeName;
    }

    //*****************************************************************************
    /** Save this processing instruction in XML source form in InputWriter.
     *
     *  @param  InputWriter  The writer to which the source will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "xg_PI.save: Save '" + NodeName + "' processing instruction");  //TEMP
        InputWriter.write(xa_Keyword.PI_START_STRING);
        InputWriter.write(NodeName);
        InputWriter.write(InstructionString);
        InputWriter.write(xa_Keyword.PI_END_STRING);
    }

    //*****************************************************************************
    /** Set the value of the processing instruction.
     *
     *  @param  InputInstructionString  The value of the instruction itself
     */
    public void setInstructionString(String  InputInstructionString)
    {
        InstructionString = InputInstructionString;
    }

    //*****************************************************************************
    /** Get the type of this node.
     *
     *  @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.PI_TYPE;
    }

    //*****************************************************************************
    /** Get a summary descriptive string (intended for display in the tree view).
     *
     *  @return  A description suitable for display in the tree view
     */
    public String getSummaryString()
    {
//        String  SummaryString;
//        if (InstructionString.length() > 30)
//            SummaryString = new String("Processing instruction '" + InstructionString.substring(0, 30) + "...'");
//        else
//            SummaryString = new String("Processing instruction '" + InstructionString + "'");
//        return SummaryString;
        return(NodeName + " processing instruction");
    }

    //*****************************************************************************
    /** Get the value of the instruction.
     *
     *  @return  The value of the instruction
     */
    public String getInstructionString()
    {
        return InstructionString;
    }
}

//*****************************************************************************
