//*****************************************************************************
/*
** FILE:   xg_ExternalID.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    15Nov97  stevew  Created.
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_ExternalID - A representation of an XML external ID, which takes
*  the form:
*
*    SYSTEM "Url"
* or PUBLIC "Name" "Url"
*/
public class xg_ExternalID extends xg_Node
{
    protected boolean  SystemFlag = true;
    // If true, this is a SYSTEM type ID; if false it is a PUBLIC type ID.

    protected String   UrlValue   = null;
    // The value of the URL.

    protected String   NameValue  = null;
    // The name of the ID, which is only used for PUBLIC IDs.

    //*****************************************************************************
    /**
     * Construct an external ID.
     */
//    public xg_ExternalID()
//    {
//    }

    //*****************************************************************************
    /**
     * Set the flag which specifies whether this is SYSTEM ID (true) or PUBLIC ID
     * (false).
     *
     * @param  Whether this is a SYSTEM ID
     */
    public void setSystemFlag(boolean  InputSystemFlag)
    {
        SystemFlag = InputSystemFlag;
    }

    //*****************************************************************************
    /**
     * Set the value of the URL.
     *
     * @param  The value of the URL
     */
    public void setUrlValue(String  InputUrlValue)
    {
        UrlValue = InputUrlValue;
    }

    //*****************************************************************************
    /**
     * Set the name of the ID, which is only meaningful for PUBLIC IDs.
     *
     * @param  The value of the name
     */
    public void setName(String  InputNameValue)
    {
        NameValue = InputNameValue;
    }

    //*****************************************************************************
    /**
     * Save this external ID in XML source form in InputWriter.
     *
     * @param  InputWriter   The writer to which the external ID will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
//TBD        InputWriter.write(PrecedingWhitespace);

        if (SystemFlag)
        {
            // SYSTEM "Url"
            InputWriter.write(xa_Keyword.SYSTEM_STRING);
        }
        else
        {
            // PUBLIC "Name" "Url"
            InputWriter.write(xa_Keyword.PUBLIC_STRING);
            InputWriter.write(" \"");  //TBD Should use actual whitespace value
            InputWriter.write(NameValue);
            InputWriter.write('"');
        }

        InputWriter.write(" \"");  //TBD Should use actual whitespace value
        InputWriter.write(UrlValue);
        InputWriter.write('"');
    }

    //*****************************************************************************
    /**
     * Is this a SYSTEM ID? True means SYSTEM; false means PUBLIC.
     *
     * @return  Whether this is a SYSTEM ID
     */
    public boolean isSystemID()
    {
        return SystemFlag;
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.EXTERNAL_ID_TYPE;
    }

    //*****************************************************************************
    /**
     * Get the type of this node, using only type values defined for the DOM.
     * (Implements org.w3c.dom.Node.getNodeType.)
     *
     * @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return -1;
    }

    //*****************************************************************************
    /**
     * Get the value of the URL.
     *
     * @return  The value of the URL
     */
    public String getUrlValue()
    {
        return UrlValue;
    }

    //*****************************************************************************
    /**
     * Get the name of the ID, which is only meaningful for PUBLIC IDs.
     *
     * @return  The value of the name
     */
    public String getName()
    {
        return NameValue;
    }
}

//*****************************************************************************
