//*****************************************************************************
/*
** FILE:   xg_Exception.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    09May98  stevew  Created.
*/
package xg;

//*****************************************************************************
/** The raw data used to generate a text message. It
 *  comprises an ID (which is to be used by an external caller to retrieve a
 *  basic message text suitable for the appropriate locale) and an array of
 *  parameters which are to be merged into the final text.
 */
public class xg_Exception extends Exception
{
    /** The ID of the error. This is intended to be used as the key to retrieve
     *  an error message text (to provide multi-lingual support) - although at
     *  present the whole message text is placed in here. */
    protected String    MessageID      = null;

    /** An array of parameters to be inserted in the message whose ID is given
     *  in the MessageID attribute. */
    protected Object[]  ParameterArray = null;

    /** The location in the source of the start of the area to highlight. */
    protected int       StartPosition  = -1;

    /** The location in the source of the end of the area to highlight. */
    protected int       EndPosition    = -1;

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID       ID to be used to retrieve message text
     *  @param  InputParameterArray  Array of parameter values
     *  @param  InputStartPosition   Start of area in source to highlight
     *  @param  InputEndPosition     End of area in source to highlight
     */
    public xg_Exception(String    InputMessageID,
                        Object[]  InputParameterArray,
                        int       InputStartPosition,
                        int       InputEndPosition)
    {
        MessageID      = InputMessageID;
        ParameterArray = InputParameterArray;
        StartPosition  = InputStartPosition;
        EndPosition    = InputEndPosition;
    }

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID       ID to be used to retrieve message text
     *  @param  InputParameterArray  Array of parameter values
     */
    public xg_Exception(String    InputMessageID,
                        Object[]  InputParameterArray)
    {
        MessageID      = InputMessageID;
        ParameterArray = InputParameterArray;
    }

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID       ID to be used to retrieve message text
     *  @param  InputStartPosition   Start of area in source to highlight
     *  @param  InputEndPosition     End of area in source to highlight
     */
    public xg_Exception(String  InputMessageID,
                        int     InputStartPosition,
                        int     InputEndPosition)
    {
        MessageID      = InputMessageID;
        StartPosition  = InputStartPosition;
        EndPosition    = InputEndPosition;
    }

    //*****************************************************************************
    /** Constructor.
     *
     *  @param  InputMessageID  ID to be used to retrieve message text
     */
    public xg_Exception(String  InputMessageID)
    {
        MessageID = InputMessageID;
    }

    //*****************************************************************************
    /** Get the ID to be used to retrieve message text.
     *
     *  @return  ID to be used to retrieve message text
     */
    public String getMessageID()
    {
        return MessageID;
    }

    //*****************************************************************************
    /** Get the array of parameter values.
     *
     *  @return  Array of parameter values
     */
    public Object[] getParameterArray()
    {
        return ParameterArray;
    }

    //*****************************************************************************
    /** Get the location in the source of the start of the area to highlight.
     *
     *  @return  Start of area in source to highlight
     */
    public int getStartPosition()
    {
        return StartPosition;
    }

    //*****************************************************************************
    /** Get the location in the source of the end of the area to highlight.
     *
     *  @return  End of area in source to highlight
     */
    public int getEndPosition()
    {
        return EndPosition;
    }
}

//*****************************************************************************
