//*****************************************************************************
/*
** FILE:   xg_Dtd.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    03Nov97  stevew  Created.
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_Dtd - A Document Type Definition.
*/
public class xg_Dtd extends xg_Node
{
    //*****************************************************************************
    /**
     * Construct a DTD with no type and no name.
     */
    public xg_Dtd()
    {
    }

    //*****************************************************************************
    /**
     * Construct a DTD with a name.
     *
     * @param  InputNodeName  The name of the DTD
     */
    public xg_Dtd(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /**
     * Save this DTD (and its children) in XML source form in InputWriter.
     *
     * @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "xg_Dtd.save: Save DTD '" + NodeName + "'");  //TEMP

        // Save the start tag (except for the end of it).
        InputWriter.write(xa_Keyword.DOCTYPE_START_STRING);
        InputWriter.write(' ');       //TBD Replace with actual whitespace
        InputWriter.write(NodeName);

        // If there is no content,  it is an empty tag, and we just need to save
        // the end of it; otherwise save the content and then the end tag.
/*        if (getChildCount() == 0)
            InputWriter.write(xa_Keyword.SLASH_CHAR);  // Flag this as an empty element
        else
        {
            InputWriter.write(xa_Keyword.TAG_END_CHAR);   // Save the end of the start tag
            super.save(InputWriter);  // Save the content

            // Save the end tag.
            eh_Debug.Add(7, "xg_Dtd.Save: Save end tag for '" + NodeName + "'");
            InputWriter.write(xa_Keyword.END_TAG_START_STRING);
            InputWriter.write(NodeName);
        }
*/
        InputWriter.write(xa_Keyword.TAG_END_CHAR);
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.DOCTYPE_DECL_TYPE;
    }

    //*****************************************************************************
    /**
     * Get the type of this node, using only type values defined for the DOM.
     * (Implements org.w3c.dom.Node.getNodeType.)
     *
     * @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return -1;
    }

    //*****************************************************************************
    /**
     * Return a string representation of the DTD (intended for use as debug
     * output).
     *
     * @return  String representing the DTD name.
     */
    public String toString()
    {
        return ("DTD '" + NodeName + "'");
    }
}

//*****************************************************************************
