//*****************************************************************************
/*
** FILE:   xg_Document.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    02Nov97  stevew  Created.
*/
package xg;

import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import com.sun.java.swing.text.Document;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** An XML document.
*/
public class xg_Document extends xg_Node
{
    /** The root element of this document. This attribute is set the first time
     *  getRootElement() is called. */
    xg_Element  RootElement    = null;

    /** The associated swing.text.Document. */
    Document    OwningDocument = null;

    //*****************************************************************************
    /** Construct a document with no name.
     */
    public xg_Document()
    {
    }

    //*****************************************************************************
    /** Construct a document with a name.
     *
     * @param  InputNodeName  The name of the document
     */
    public xg_Document(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** Clear out the contents of this document.
     */
    public void reset()
    {
        super.reset();
        RootElement = null;
    }

    //*****************************************************************************
    /** Save this document (and its children) in XML source form in InputWriter.
     *
     *  @param  InputWriter   The writer to which the XML will be written
     */
/*    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "XE_Document.save: Save document '" + NodeName + "'");  //TEMP
        super.save(InputWriter);  // Save the content
    }
*/
    //*****************************************************************************
    /** Set the swing.text.Document associated with this node.
     *
     *  @param  InputDocument  The swing.text.Document to which this node belongs
     */
    public void setDocument(Document  InputDocument)
    {
        eh_Debug.add(6, "xg_Document.setDocument");
        OwningDocument = InputDocument;
    }

    //*****************************************************************************
    /** Get the type of this node.
     *
     *  @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.DOCUMENT_TYPE;
    }

    //*****************************************************************************
    /** Get the root element of this document.
     *
     *  @return  The root element of this document
     */
    public xg_Element getRootElement()
    {
        eh_Debug.add(7, "xg_Document.getRootElement:");

        if (RootElement == null)
        {
            xg_Node  CurrentChild = null;
            for (int ChildIndex = 0; ChildIndex < getChildCount(); ChildIndex++)
            {
                CurrentChild = (xg_Node)getChildAt(ChildIndex);
                if (CurrentChild instanceof xg_Element)
                {
                    RootElement = (xg_Element)CurrentChild;
                    break;
                }
            }
        }
        return RootElement;
    }

    //*****************************************************************************
    /** Get a summary descriptive string (intended for display in the tree view).
     *
     *  @return  A description suitable for display in the tree view
     */
    public String getSummaryString()
    {
        String  SummaryString = null;
        if (NodeName == null)
            SummaryString = new String("Document");
        else
            SummaryString = new String("Document '" + NodeName + "'");
        return SummaryString;
    }

    //*****************************************************************************
    /** Return a string representation of the document (intended for use as debug
     *  output).
     *
     *  @return  String representing the document name.
     */
    public String toString()
    {
        return(getSummaryString() );
    }

    //*****************************************************************************
    //*Methods*implementing*com.sun.java.swing.text.Element************************
    //*****************************************************************************
    /** Get the swing.text.Document associated with this node.
     *
     *  @return  The swing.text.Document to which this node belongs
     */
    public Document getDocument()
    {
//        eh_Debug.add(6, "xg_Document.getDocument");
        return OwningDocument;
    }
}

//*****************************************************************************
