//*****************************************************************************
/*
** FILE:   xg_Comment.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    13Oct97  stevew  Created.
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_Comment - A representation of an XML comment.
*/
public class xg_Comment extends xg_Node
{
    /** The value of the comment itself (stripped of the <!-- and the start and
     *  --> at the end. */
    protected String  CommentValue = null;

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xg_Comment()
    {
    }

    //*****************************************************************************
    /**
     * Save this comment in XML source form in InputWriter.
     *
     * @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        InputWriter.write(PrecedingWhitespace);
        InputWriter.write(xa_Keyword.COMMENT_START_STRING);
        InputWriter.write(CommentValue);
        InputWriter.write(xa_Keyword.COMMENT_END_STRING);
    }

    //*****************************************************************************
    /**
     * Set the value of the comment.
     *
     * @param  InputCommentValue The value of the comment
     */
    public void setCommentValue(String  InputCommentValue)
    {
        CommentValue = InputCommentValue;
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.COMMENT_TYPE;
    }

    //*****************************************************************************
    /**
     * Get the value of the comment.
     *
     * @return  The value of the comment
     */
    public String getCommentValue()
    {
        return CommentValue;
    }

    //*****************************************************************************
    /**
     * Get a summary descriptive string suitable for display in the tree view.
     *
     * @return  A description suitable for display in the tree view
     */
/*    public String getSummaryString()
    {
        return (toString() );
    }
*/
    //*****************************************************************************
    /**
     * Return a string representation of the comment.
     *
     * @return  A description suitable for display
     */
    public String toString()
    {
        String  SummaryString;
        if (CommentValue == null)
            SummaryString = new String("Uninitialised comment");
        else if (CommentValue.length() > 30)
            SummaryString = new String("Comment '" + CommentValue.substring(0, 30) + "...'");
        else
            SummaryString = new String("Comment '" + CommentValue + "'");
        return SummaryString;
    }
}

//*****************************************************************************
