//*****************************************************************************
/*
** FILE:   xg_Cdata.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    14Apr98  stevew  Created.
**    04Aug98  stevew  Changed to extend xg_Text instead of xg_Node (to bring
**                      into line with DOM).
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

//import eh.eh_Debug;

import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/** A representation of a piece of character data (CDATA) within the content of
 *  an XML element.
 */
public class xg_Cdata extends xg_Text
{
    //*****************************************************************************
    /** Default constructor.
     */
    public xg_Cdata()
    {
    }

    //*****************************************************************************
    /** Construct a piece of character data with a value.
     *
     *  @param  InputTextValue  The value of the character data itself
     */
    public xg_Cdata(String  InputTextValue)
    {
       TextValue = InputTextValue;
    }

    //*****************************************************************************
    /** Save this character data in XML source form in InputWriter.
     *
     *  @param  InputWriter   The writer to which the source will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
//        eh_Debug.add(8, "xg_Cdata.save: Save character data '" + TextValue + "'");  //TEMP
        InputWriter.write(xa_Keyword.CDATA_START_STRING);
        InputWriter.write(TextValue);
        InputWriter.write(xa_Keyword.CDATA_END_STRING);
    }

    //*****************************************************************************
    /** Write this character data to InputWriter.
     *
     *  @param  InputWriter   The writer to which the content will be written
     */
    public void writeContent(Writer  InputWriter) throws IOException
    {
//        eh_Debug.add(8, "xg_Cdata.writeContent:");
        InputWriter.write(TextValue);
    }

    //*****************************************************************************
    /** Get the type of this node.
     *
     *  @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.CDATA_TYPE;
    }

    //*****************************************************************************
    /** Get the type of this node, using only type values defined for the DOM.
     *  (Implements org.w3c.dom.Node.getNodeType.)
     *
     *  @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return -1;
    }

    //*****************************************************************************
    /** Return a string representation of the character data.
     *
     *  @return  A description suitable for display
     */
    public String toString()
    {
        String  SummaryString;
        if (TextValue == null)
            SummaryString = new String("Uninitialised character data");
        else if (TextValue.length() > 30)
            SummaryString = new String("Character data '" + TextValue.substring(0, 30) + "...'");
        else
            SummaryString = new String("Character data '" + TextValue + "'");
        return SummaryString;
    }
}

//*****************************************************************************
