//*****************************************************************************
/*
** FILE:   xg_AttListDecl.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    09Nov97  stevew  Created.
*/
package xg;

import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import java.util.Vector;
import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_AttListDecl - An attribute list declaration, within a DTD.
*/
public class xg_AttListDecl extends xg_Node
{
    /** List of xg_AttDecls. */
    protected Vector  AttDeclList = null;

    // Constants for the possible attribute types.
    public final static int ATT_TYPE_ENUMERATION = -1;  /** Enumerated */
    public final static int ATT_TYPE_NOTATION    =  0;  /** Enumerated */
    public final static int ATT_TYPE_CDATA       =  1;  /** String */
    public final static int ATT_TYPE_ID          =  2;  /** Tokenized */
    public final static int ATT_TYPE_IDREF       =  3;  /** Tokenized */
    public final static int ATT_TYPE_IDREFS      =  4;  /** Tokenized */
    public final static int ATT_TYPE_ENTITY      =  5;  /** Tokenized */
    public final static int ATT_TYPE_ENTITIES    =  6;  /** Tokenized */
    public final static int ATT_TYPE_NMTOKEN     =  7;  /** Tokenized */
    public final static int ATT_TYPE_NMTOKENS    =  8;  /** Tokenized */

    public final static String ATT_TYPE_CDATA_STRING      = "CDATA";
    public final static String ATT_TYPE_ENTITY_STRING     = "ENTITY";
    public final static String ATT_TYPE_ENTITIES_STRING   = "ENTITIES";
    public final static String ATT_TYPE_ID_STRING         = "ID";
    public final static String ATT_TYPE_IDREF_STRING      = "IDREF";
    public final static String ATT_TYPE_IDREFS_STRING     = "IDREFS";
    public final static String ATT_TYPE_NMTOKEN_STRING    = "NMTOKEN";
    public final static String ATT_TYPE_NMTOKENS_STRING   = "NMTOKENS";
    public final static String ATT_TYPE_NOTATION_STRING   = "NOTATION";

    // Static data attributes.
    /** Hashtable used to find a keyword definition given an integer type. */
    private static Vector  TypeVector  = null;

    //*****************************************************************************
    /**
     * Construct an attribute list declaration with no type and no name.
     */
    public xg_AttListDecl()
    {
        if (TypeVector == null)
            initialise();
    }

    //*****************************************************************************
    /**
     * Construct an attribute list declaration with a name.
     *
     * @param  InputNodeName  The name of the attribute list
     */
    public xg_AttListDecl(String InputNodeName)
    {
        super(InputNodeName);
        if (TypeVector == null)
            initialise();
    }

    //*****************************************************************************
    /**
     * Save this attribute list declaration (and its children) in XML source form
     * in InputWriter.
     *
     * @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "xg_AttListDecl.save: Save ATTLIST '" + NodeName + "'");  //TEMP

        // Save the start tag (except for the end of it).
        InputWriter.write(xa_Keyword.TAG_START_CHAR);
        InputWriter.write(NodeName);

        // Save the attribute declarations (if there are any).
        if (AttDeclList != null)
        {
            xg_Attribute  CurrentAttDecl = null;
            for (int CurrentChildIndex = 0;
                 CurrentChildIndex < getChildCount();
                 CurrentChildIndex++)
            {
                CurrentAttDecl = (xg_Attribute)AttDeclList.elementAt(CurrentChildIndex);
                CurrentAttDecl.save(InputWriter);  // Save this attribute decl
            }
        }

        InputWriter.write(xa_Keyword.TAG_END_CHAR);
    }

    //*****************************************************************************
    /**
     * Add an attribute declaration.
     *
     * @param  InputAttDecl    The attribute declaration to be added
     */
    public void addAttDecl(xg_AttDecl  InputAttDecl)
    {
        if (AttDeclList == null)
            AttDeclList = new Vector();

        AttDeclList.addElement(InputAttDecl);
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.ATTLIST_DECL_TYPE;
    }

    //*****************************************************************************
    /**
     * Get the type of this node, using only type values defined for the DOM.
     * (Implements org.w3c.dom.Node.getNodeType.)
     *
     * @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return -1;
    }

    //*****************************************************************************
    /**
     * Return a string representation of the element (intended for use as debug
     * output).
     *
     * @return  String representing the entity name.
     */
    public String toString()
    {
        return ("Att list declaration '" + NodeName + "'");
    }

    //*****************************************************************************
    /**
     * Initialise the vector of the allowed attribute types.
     */
    static public void initialise()
    {
        eh_Debug.add(7, "xg_AttListDecl.initialise:");
        TypeVector = new Vector();

//        TypeVector.insertElementAt(, ATT_TYPE_ENUMERATION);
        TypeVector.insertElementAt(ATT_TYPE_NOTATION_STRING, ATT_TYPE_NOTATION);
        TypeVector.insertElementAt(ATT_TYPE_CDATA_STRING,    ATT_TYPE_CDATA);
        TypeVector.insertElementAt(ATT_TYPE_ID_STRING,       ATT_TYPE_ID);
        TypeVector.insertElementAt(ATT_TYPE_IDREF_STRING,    ATT_TYPE_IDREF);
        TypeVector.insertElementAt(ATT_TYPE_IDREFS_STRING,   ATT_TYPE_IDREFS);
        TypeVector.insertElementAt(ATT_TYPE_ENTITY_STRING,   ATT_TYPE_ENTITY);
        TypeVector.insertElementAt(ATT_TYPE_ENTITIES_STRING, ATT_TYPE_ENTITIES);
        TypeVector.insertElementAt(ATT_TYPE_NMTOKEN_STRING,  ATT_TYPE_NMTOKEN);
        TypeVector.insertElementAt(ATT_TYPE_NMTOKENS_STRING, ATT_TYPE_NMTOKENS);
    }
}

//*****************************************************************************
