//*****************************************************************************
/*
** FILE:   xg_AttDecl.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    09Nov97  stevew  Created.
*/
package xg;

import xa.xa_AttTypeChoiceList;
import xa.xa_Keyword;
import xa.xa_NodeTypeChoiceList;

import eh.eh_Debug;

import java.util.Vector;
import java.io.IOException;
import java.io.Writer;

//*****************************************************************************
/**
*  Class xg_AttDecl - An attribute declaration, within an attribute list
*  declaration within a DTD.
*/
public class xg_AttDecl extends xg_Node
{
    protected int     AttDeclType      = 0;

    protected Vector  AllowedValueList = null;
    /** List of strings defining the possible values which this attribute may
     *  have. */

    protected int     DefaultType      = IMPLIED;
    /** Defines whether and how a default value is applied. The possible values
     *  are:
     *
     *   REQUIRED: This attribute must be present.
     *   IMPLIED:  This attribute may be omitted.
     *   FIXED:    If present, this attribute's value must equal the default.
     *   SIMPLE:   This attribute has a simple default value. */

    protected String  DefaultValue     = null;
    /** The default value of this attribute. */

    // Constants for the possible attribute types.
    public final static int    ENUMERATION_TYPE = -1;
    /** Constant to identify an enumerated type. Constants for other types are
     *  defined in xa_AttTypeChoiceList. */

    // Constants for default type.
    public final static int    REQUIRED = 0;  /** #REQUIRED */
    public final static int    IMPLIED  = 1;  /** #IMPLIED */
    public final static int    FIXED    = 2;  /** #FIXED */
    public final static int    SIMPLE   = 3;  /** Just default value */

    public final static String REQUIRED_STRING = "REQUIRED";
    public final static String IMPLIED_STRING  = "IMPLIED";
    public final static String FIXED_STRING    = "FIXED";

    //*****************************************************************************
    /**
     * Construct an attribute declaration with no type and no name.
     */
    public xg_AttDecl()
    {
    }

    //*****************************************************************************
    /**
     * Construct an attribute declaration with a type and name.
     *
     * @param  InputAttDeclType  The type of the attribute declaration
     * @param  InputAttName      The name of the attribute
     */
    public xg_AttDecl(int InputAttDeclType, String InputAttName)
    {
        super(InputAttName);
        AttDeclType = InputAttDeclType;
    }

    //*****************************************************************************
    /**
     * Save this attribute declaration (and its children) in XML source form
     * in InputWriter.
     *
     * @param  InputWriter   The writer to which the XML will be written
     */
    public void save(Writer  InputWriter) throws IOException
    {
        eh_Debug.add(7, "xg_AttDecl.Save: Save attribute decl '" + NodeName + "'");  //TEMP
        InputWriter.write(PrecedingWhitespace);
        InputWriter.write(NodeName);   // Save the attribute name

        switch (AttDeclType)
        {
            case xa_AttTypeChoiceList.NOTATION_TYPE:
                // ' NOTATION '
                InputWriter.write(' '+ xa_AttTypeChoiceList.NOTATION_STRING + ' ');
//                break;      // Drop through!

            case ENUMERATION_TYPE:
                // Save the list of allowed values (if there are any).
                InputWriter.write(' ' + xa_Keyword.OPEN_PAREN_CHAR);  // ' ('
//TBD
/*                if (AllowedValueList != null)
                {
                    String   CurrentAllowedValue = null;
                    boolean  PrecedingValueFlag  = false;
                    for (int CurrentChildIndex = 0;
                             CurrentChildIndex < AllowedValueList.getChildCount();
                             CurrentChildIndex++)
                    {
                        if (PrecedingValueFlag)
                            InputWriter.write(xa_Keyword.OR_CHAR);  // '|'
                        else
                            PrecedingValueFlag = true;

                        CurrentAllowedValue = (String)AllowedValueList.elementAt(CurrentChildIndex);
                        InputWriter.write(CurrentAllowedValue);  // Save this allowed value
                    }
                }
*/
                InputWriter.write(xa_Keyword.CLOSE_PAREN_CHAR);  // ')'
                break;

            default:
                break;
        }


        InputWriter.write(xa_Keyword.TAG_END_CHAR);
    }

    //*****************************************************************************
    /**
     * Add an allowed value.
     *
     * @param  InputAllowedValue  The allowed value to be added
     */
    public void addAllowedValue(String  InputAllowedValue)
    {
        if (AllowedValueList == null)
            AllowedValueList = new Vector();

        AllowedValueList.addElement(InputAllowedValue);
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  InputAttDeclType  The type of this node
     */
    public void setType(int  InputAttDeclType)
    {
        AttDeclType = InputAttDeclType;
    }

    //*****************************************************************************
    /**
     * Get the type of this node.
     *
     * @return  The type of this node
     */
    public int getType()
    {
        return xa_NodeTypeChoiceList.ATT_DECL_TYPE;
    }

    //*****************************************************************************
    /**
     * Get the type of this node, using only type values defined for the DOM.
     * (Implements org.w3c.dom.Node.getNodeType.)
     *
     * @return  The DOM type of this node
     */
    public int getNodeType()
    {
        return -1;
    }

    //*****************************************************************************
    /**
     * Return a string representation of the attribute declaration (intended for
     * use as debug output).
     *
     * @return  String representing the attribute type and its name.
     */
    public String toString()
    {
        return ("Att declaration '" + NodeName + "', type " + AttDeclType);
    }

    //*****************************************************************************
    /**
     * Get the default type (ie. the type of defaulting) of the attribute.
     *
     * @return  The default type of the attribute
     */
    public int getDefaultType()
    {
        return DefaultType;
    }

    //*****************************************************************************
    /**
     * Get the default value of the attribute.
     *
     * @return  The default value of the attribute
     */
    public String getDefaultValue()
    {
        return DefaultValue;
    }

    //*****************************************************************************
    /**
     * Check if a value is allowed (ie. is on the list of allowed values).
     *
     * @param   InputValue  The value we are testing to see if it is allowed
     * @return  True if the InputValue is one of the allowed values; false if not.
     */
    public boolean isValueAllowed(String  InputValue)
    {
        return (    AllowedValueList != null
                 && AllowedValueList.indexOf(InputValue) != -1);
    }

    //*****************************************************************************
    /**
     * Set the default type of this attribute.
     *
     * @param  InputDefaultType   The default type of this attribute
     */
    public void setDefaultType(int  InputDefaultType)
    {
        DefaultType = InputDefaultType;
    }

    //*****************************************************************************
    /**
     * Set the default value of this attribute.
     *
     * @param  InputDefaultValue   The default value of this attribute
     */
    public void setDefaultValue(String  InputDefaultValue)
    {
        DefaultValue = InputDefaultValue;
    }
}

//*****************************************************************************
