//*****************************************************************************
/*
** FILE:   xe_Token.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    11Oct97  stevew  Created.
*/
package xe;

//import eh.eh_Debug;

import xg.xg_Value;

//*****************************************************************************
/**
*  Class xe_Token - A token parsed from an XML source.
*
*  A token has a type, a value (optionally) and can record the whitespace that
*  precedes the token.
*/
public class xe_Token
{
    private int             TokenType;
    // The the type of this token

    private xg_Value        TokenValue = null;
    // The value of this token, which is not recorded for every type of token.
    // It contains the token's preceding whitespace (if it has any).

    //*****************************************************************************
    /**
     * Construct a token with no value defined.
     *
     * @param  InputTokenType  Type of the token
     */
    public xe_Token(int  InputTokenType)
    {
        TokenType  = InputTokenType;
        TokenValue = new xg_Value();
    }

    //*****************************************************************************
    /**
     * Construct a token which has a string value.
     *
     * @param  InputTokenType  Type of the token
     * @param  InputValue      The string value for the token
     */
    public xe_Token(int InputTokenType, String InputValue)
    {
        TokenType  = InputTokenType;
        TokenValue = new xg_Value(InputValue);
    }

    //*****************************************************************************
    /**
     * Get the type of the token (expected to be one of the standard values listed
     * in xe_TokenType).
     *
     * @return  The type of the token
     */
    public int getType()
    {
        return TokenType;
    }

    //*****************************************************************************
    /**
     * Get the value of the token.
     *
     * @return  Value of token
     */
    public xg_Value getValue()
    {
        return TokenValue;
    }

    //*****************************************************************************
    /**
     * Get the value of the token as a string.
     *
     * @return  String value or null
     */
    public String getStringValue()
    {
        return TokenValue.getValue();
    }

    //*****************************************************************************
    /**
     * Get the value of the preceding whitespace.
     *
     * @return  String value or null
     */
    public String getPrecedingWhitespace()
    {
        return TokenValue.getPrecedingWhitespace();
    }

    //*****************************************************************************
    /**
     * Set the type of the token.
     *
     * @param  The type of the token
     */
    public void setType(int  InputTokenType)
    {
        TokenType = InputTokenType;
    }

    //*****************************************************************************
    /**
     * Set the value of the token.
     *
     * @param  The value of the token
     */
    public void setValue(String  InputTokenValue)
    {
        TokenValue.setValue(InputTokenValue);
    }

    //*****************************************************************************
    /**
     * Set the value of the preceding whitespace.
     *
     * @param  InputPrecedingWhitespace   Value of the preceding whitespace
     */
    public void setPrecedingWhitespace(String  InputPrecedingWhitespace)
    {
        TokenValue.setPrecedingWhitespace(InputPrecedingWhitespace);
    }

    //*****************************************************************************
    /**
     * Return a string representation of the token (intended for use as debug
     * output).
     *
     * @return  String representing the token type and its value(s).
     */
    public String toString()
    {
        String  StringRepresentation = typeToString();

        if (TokenValue.getValue() != null)
            StringRepresentation += "; Value = " + TokenValue.getValue();

        return StringRepresentation;
    }

    //*****************************************************************************
    /**
     * Return the token type as a string.
     *
     * @return  String value or null
     */
    protected String typeToString()
    {
        return xe_TokenType.toString(TokenType);
    }
}

//*****************************************************************************
