//*****************************************************************************
/*
** FILE:   xe_PIParser.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    14Apr98  stevew  Created.
*/
package xe;

import eh.eh_Debug;

import xg.xg_Node;
import xg.xg_PI;
import xa.xa_Keyword;

import java.io.IOException;

//*****************************************************************************
/** Parser for an XML processor instruction, assuming the beginning ('<?Name')
 *  has already been parsed. Everything up to the closing '?>' is treated as
 *  part of the instruction, irrespective of what it is.
 *
 *    <!?Name ... ?>
 */
public class xe_PIParser extends xe_Parser
{
    //*****************************************************************************
    /** Parse a processing instruction, putting the result in a newly-created PI
     *  entity.
     *
     *  @return  The parsed processing instruction node
     */
    public xg_Node parse() throws IOException
    {
        eh_Debug.add(8, "xe_PIParser.parse: Parse processing instruction");

        // Create new processing instruction object.
        xg_PI  NewPI = (xg_PI)createNode("xg.xg_PI");
//        xg_PI  NewPI = (xg_PI)TheParseManager.createEntity(EntityName,
//                                                           EntityType,
//                                                           "xg.xg_PI",
//                                                           ParentNode);
        // Parse the value of the processing instruction.
        String  InstructionString = TheParseManager.parseUntil(xa_Keyword.PI_END_STRING);
        NewPI.setInstructionString(InstructionString);

        return NewPI;
    }
}

//*****************************************************************************
