//*****************************************************************************
/*
** FILE:   xe_ExternalIDParser.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    24Nov97  stevew  Created.
*/
package xe;

import xg.xg_Dtd;
import xg.xg_ExternalID;
import xg.xg_Node;

import eh.eh_Debug;

import java.io.IOException;

//*****************************************************************************
/**
*  Class xe_ExternalIDParser - parser for an external ID within the DTD of an
*  XML document, assuming its first token has already been parsed. External IDs
*  have the roughly following form:
*
*     SYSTEM "Url"
*  or PUBLIC "Name" "Url"
*
*  The initial 'SYSTEM' or 'PUBLIC' are assumed to have been parsed already -
*  and been placed in the EntityName attribute.
*/
public class xe_ExternalIDParser extends xe_Parser
{
    //*****************************************************************************
    /**
     * Parse an external ID, putting the result in a newly-created external ID
     * object.
     *
     * @return  The parsed external ID
     */
    public xg_Node parse() throws IOException
    {
        eh_Debug.add(5, "xe_ExternalIDParser.parse: Start parsing external ID '"
                               + EntityName + "'");

        xg_ExternalID  NewExternalID = new xg_ExternalID();
        xe_Token       CurrentToken  = null;

        if (EntityName.compareTo(xe_TokenType.SYSTEM_STRING) == 0)
            // This is SYSTEM.
            NewExternalID.setSystemFlag(true);
        else if (EntityName.compareTo(xe_TokenType.PUBLIC_STRING) == 0)
        {
            // This is PUBLIC.
            eh_Debug.add(5, "xe_ExternalIDParser.parse: NewExternalID.SetSystemFlag(false);");
            NewExternalID.setSystemFlag(false);
            eh_Debug.add(5, "xe_ExternalIDParser.parse: CurrentToken = TheParseManager.parseLiteralToken(true);");
            CurrentToken = TheParseManager.parseLiteralToken(true);
            eh_Debug.add(5, "xe_ExternalIDParser.parse: NewExternalID.SetName(CurrentToken.getStringValue());");
            NewExternalID.setName(CurrentToken.getStringValue());
        }
        else
            TheParseManager.throwParseException("External ID declaration must be either '"
                                                    + xe_TokenType.SYSTEM_STRING + "' or '"
                                                    + xe_TokenType.PUBLIC_STRING + "'");

        eh_Debug.add(5, "xe_ExternalIDParser.parse: CurrentToken = TheParseManager.parseLiteralToken(true);");
        CurrentToken = TheParseManager.parseLiteralToken(true);
        NewExternalID.setUrlValue(CurrentToken.getStringValue());

        eh_Debug.add(7, "xe_ExternalIDParser: Completed parsing external ID '" + EntityName + "'");
        return NewExternalID;
    }
}

//*****************************************************************************
