//*****************************************************************************
/*
** FILE:   xe_CommentParser.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    11Oct97  stevew  Created.
*/
package xe;

import xm.xm_ParseException;

import eh.eh_Debug;

import xg.xg_Comment;
import xg.xg_Node;
import xa.xa_Keyword;

import java.io.IOException;

//*****************************************************************************
/** Parser for an XML comment, assuming the beginning ('<!--') has already been
 *  parsed.
 *
 *    <!-- ... -->
 */
public class xe_CommentParser extends xe_Parser
{
    //*****************************************************************************
    /** Parse the body of an XML comment, putting the result in a newly-created
     *  comment entity.
     *
     *  @return     The parsed comment entity
     *  @exception  xm_ParseException  XML wellformedness error
     *  @exception  IOException        Error reading from source reader
     */
    public xg_Node parse() throws xm_ParseException, IOException
    {
        eh_Debug.add(8, "xe_CommentParser.parse: Parse comment");

        // Create new comment object.
        xg_Comment  NewComment = (xg_Comment)createNode("xg.xg_Comment");

        // Parse the value of the comment.
        String  CommentString = TheParseManager.parseUntil(xa_Keyword.COMMENT_END_STRING);
        eh_Debug.add(6, "xe_CommentParser.parse: Comment value = '" + CommentString + "'");
        NewComment.setCommentValue(CommentString);

        // Does the comment contain an embedded '--' (which is illegal)?
        checkIllegalContent(CommentString);

        return NewComment;
    }

    //*****************************************************************************
    /** If the InputComment contains '--' (which it shouldn't!), report an error.
     *  The severity of the error depends on how strictly we are currently applying
     *  XML syntax.
     *
     *  @param  InputComment  The comment itself
     *  @return               The parsed comment entity
     */
    public void checkIllegalContent(String  InputCommentString) throws IOException
    {
        int  IllegalCharsLocation = InputCommentString.indexOf("--");
        if (IllegalCharsLocation != -1)
        {
            if (TheParseManager.getStrictXmlSyntaxFlag() )
                TheParseManager.throwParseException("'--' embedded within a comment");
            else
                TheParseManager.reportWarning("'--' embedded within a comment, but ignoring it",
                                              InputCommentString.length() - IllegalCharsLocation + 3);
        }
    }
}

//*****************************************************************************
