//*****************************************************************************
/*
** FILE:   xe_CdataParser.java
**
** (c) 1997 Steve Withall.
**
** HISTORY:
**    14Apr98  stevew  Created.
*/
package xe;

import xm.xm_ParseException;

import eh.eh_Debug;

import xg.xg_Cdata;
import xg.xg_Node;
import xa.xa_Keyword;

import java.io.IOException;

//*****************************************************************************
/** Parser for XML character data, assuming the beginning ('<![CDATA[') has
 *  already been parsed. Everything up to the closing ']]>' is treated as part
 *  of the data, irrespective of what it is.
 *
 *    <![CDATA[ ... ]]>
 */
public class xe_CdataParser extends xe_Parser
{
    //*****************************************************************************
    /** Parse a body of character data, putting the result in a newly-created
     *  CDATA entity.
     *
     *  @return     The parsed character data node
     *  @exception  xm_ParseException  XML wellformedness error
     *  @exception  IOException        Error reading from source reader
     */
    public xg_Node parse() throws xm_ParseException, IOException
    {
        eh_Debug.add(8, "xe_CdataParser.parse: Parse character data");

        // Create new character object.
        xg_Cdata  NewCdata = (xg_Cdata)createNode("xg.xg_Cdata");
//        xg_Cdata  NewCdata = (xg_Cdata)TheParseManager.createEntity(EntityName,
//                                                                    EntityType,
//                                                                    "xg.xg_Cdata",
//                                                                    ParentNode);
        // Parse the value of the character data.
        String  DataString = TheParseManager.parseUntil(xa_Keyword.CDATA_END_STRING);
        NewCdata.setTextValue(DataString);
        return NewCdata;
    }
}

//*****************************************************************************
