/*
** FILE:   xc_ElementCustomizer.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    06Jun98  stevew  Created, based  on xc_NodeCustomizer.
*/
package xc;

import xg.xg_AttList;
import xg.xg_Attribute;
import xg.xg_Element;
import xg.xg_Node;

import eh.eh_Debug;

import com.sun.java.swing.table.AbstractTableModel;
import com.sun.java.swing.table.TableModel;

import com.sun.java.swing.Box;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;

import java.awt.BorderLayout;
import java.awt.Color;

//*****************************************************************************
/** A node customizer for editing an xg_Element.
 */
public class xc_ElementCustomizer extends xc_NodeCustomizer
{
	/** The element currently being displayed. */
	protected xg_Element  CurrentElement = null;

	/** The attributes of the current element. */
	xg_AttList            CurrentAttList = null;

    // Attributes relating to the display of the element's attributes.
    /** Panel for the display of the element's attributes. */
    JPanel                AttsPanel          = null;

    /** Table displaying the element's attributes. */
    JTable                AttTable           = null;

    /** Model of the attribute data for display in the AttTable. */
    AttTableModel         TheAttTableModel   = null;

    /** Scroller for the table of attributes. */
    JScrollPane           AttTableScrollPane = null;

    // Buttons.
    JButton               ApplyButton  = new JButton("Apply");
    JButton               RevertButton = new JButton("Revert");

    //*****************************************************************************
    /** Default constructor.
     */
    public xc_ElementCustomizer()
    {
    }

    //*****************************************************************************
    /** Add all required tabs - which is expected to be overridden in derived
     *  classes (which is why its contents are not merely called directly from the
     *  constructor).
     */
    public void addTabs()
    {
        addAttsTab();
        super.addTabs();
    }

    //*****************************************************************************
    /** Add 'Attributes' tab to display the element's attributes.
     */
    public void addAttsTab()
    {
        AttsPanel = new JPanel();
        EditTabbedPane.addTab("Attributes", AttsPanel);

	    AttsPanel.setLayout(new BorderLayout());

        // Set up table for the attributes.
        TheAttTableModel = new AttTableModel();
        AttTable = new JTable(TheAttTableModel);
        AttTable.setBackground(Color.lightGray);
        AttTableScrollPane = new JScrollPane(AttTable);
        AttsPanel.add(AttTableScrollPane, BorderLayout.CENTER);

        initAttsTabButtonPanel();
    }

    //*****************************************************************************
    /** Initialise the panel of buttons at the bottom of the attributes tab.
     */
    protected void initAttsTabButtonPanel()
    {
        eh_Debug.add(7, "xc_ElementCustomizer.initAttsTabButtonPanel");
        JPanel  ButtonPanel = new JPanel();

        // The bottom buttons.
        eh_Debug.add(5, "xc_ElementCustomizer.initAttsTabButtonPanel: Create button box");
        Box  ButtonBox = Box.createHorizontalBox();
        eh_Debug.add(5, "xc_ElementCustomizer.initAttsTabButtonPanel: Add buttons: "
                             + ButtonBox + ApplyButton + RevertButton);
        ApplyButton  = new JButton("Apply");
        RevertButton = new JButton("Revert");
        ButtonBox.add(ApplyButton);
        ButtonBox.add(RevertButton);

//    	ApplyButton.addActionListener(new ApplyButtonListener() );
//    	RevertButton.addActionListener(new RevertButtonListener() );

        eh_Debug.add(5, "xc_ElementCustomizer.initAttsTabButtonPanel: Add button box to panel");
        AttsPanel.add(ButtonBox, BorderLayout.SOUTH);
        eh_Debug.add(5, "xc_ElementCustomizer.initAttsTabButtonPanel: Return");
	    return;
    }

    //*****************************************************************************
    /** Set the node that is to be edited.
     *
     *  @param  InputNode  The node to edit
     */
    public void setNode(xg_Node  InputNode)
    {
        super.setNode(InputNode);
        CurrentElement = (xg_Element)InputNode;
        if (CurrentElement == null)
            CurrentAttList = null;
        else
            CurrentAttList = CurrentElement.getAttList();
    }

    //*****************************************************************************
    /** Get the tree scroll pane.
     *
     *  @return  The tree scroll pane
     */
/*    public JScrollPane getTreeScrollPane()
    {
        return TreeScrollPane;
    }
*/
    //*****************************************************************************
    /** Inner class to provide a model for the attributes for use in the table
     *  display.
     */
    class AttTableModel extends AbstractTableModel
    {
        //*****************************************************************************
        public int getColumnCount()
        {
            return 2;
        }

        //*****************************************************************************
        public int getRowCount()
        {
            int  RowCount = 0;
            if (CurrentAttList != null)
                RowCount = CurrentAttList.getLength();
            return RowCount;
        }

        //*****************************************************************************
        public Object getValueAt(int InputRowNum, int InputColumnNum)
        {
            xg_Attribute  CurrentAtt = CurrentAttList.getAtt(InputRowNum);
            String  CellValue = null;

            switch (InputColumnNum)
            {
                case 0:
                    CellValue = CurrentAtt.getName();
                    break;

                case 1:
                    CellValue = CurrentAtt.getValue();
                    break;

                default:
                    CellValue = new String("*Unknown*");
	                eh_Debug.add(5, "xc_ElementCustomizer.getValueAt: Invalid column number ("
	                                     + InputColumnNum + ") requested");
            }

            return CellValue;
        }

        //*****************************************************************************
        /** Get the name for the given column.
         *
         *  @param  InputColumnNum  the number of the column whose name is required
         */
        public String getColumnName(int InputColumnNum)
        {
            String  ColumnName = null;

            switch (InputColumnNum)
            {
                case 0:
                    ColumnName = new String("Name");
                    break;

                case 1:
                    ColumnName = new String("Value");
                    break;

                default:
                    ColumnName = new String("*Unknown*");
	                eh_Debug.add(5, "xc_ElementCustomizer.getColumnName: Invalid column number ("
	                                     + InputColumnNum + ") requested");
            }

            return ColumnName;
        }

        //*****************************************************************************
//        public Class getColumnClass(int  InputColumnNum)
//        {
//            return getValueAt(0, InputColumnNum).getClass();
//        }

        //*****************************************************************************
        public boolean isCellEditable(int InputRowNum, int InputColumnNum)
        {
            return (InputColumnNum == 1);
        }

        //*****************************************************************************
        public void setValueAt(Object InputValueObject, int InputRowNum, int InputColumnNum)
        {
	        eh_Debug.add(5, "xc_ElementCustomizer.setValueAt: Set row "
	                              + InputRowNum + ", column "
	                              + InputColumnNum + " to " + InputValueObject.toString() );
            xg_Attribute  CurrentAtt = CurrentAttList.getAtt(InputRowNum);

            switch (InputColumnNum)
            {
                case 0:
                    CurrentAtt.setName(InputValueObject.toString());
                    break;

                case 1:
                    CurrentAtt.setValue(InputValueObject.toString());
                    break;

                default:
	                eh_Debug.add(5, "xc_ElementCustomizer.setValueAt: Invalid column number ("
	                                     + InputColumnNum + ") requested");
            }
        }
    }
}

//*****************************************************************************
