//*****************************************************************************
/*
** FILE:   xa_XmlSpaceChoiceList.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    21Apr98  stevew  Created.
*/
package xa;

//*****************************************************************************
/**
*  <p>Class xa_XmlSpaceChoiceList - A list of the values allowed in an
*  'xml:space' ATTLIST declaration.</p>
*/
public class xa_XmlSpaceChoiceList extends xa_ChoiceList
{
    public final static String XML_SPACE_STRING = "xml:space";
    /** Constant value used for the 'standalone' keyword. */

    // Allowed values.
    public final static String DEFAULT_STRING   = "default";
    public final static String PRESERVE_STRING  = "preserve";

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xa_XmlSpaceChoiceList()
    {
        super(XML_SPACE_STRING);
        init();
    }

    //*****************************************************************************
    /**
     * Initialise the list of allowed values.
     */
    protected void init()
    {
        addChoice(DEFAULT_STRING,  0);
        addChoice(PRESERVE_STRING, 1);
    }
}

//*****************************************************************************
