//*****************************************************************************
/*
** FILE:   xa_StandaloneChoiceList.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    21Apr98  stevew  Created.
*/
package xa;

//*****************************************************************************
/**
*  <p>Class xa_StandaloneChoiceList - A list of the values allowed for a
*  'standalone' declaration.</p>
*/
public class xa_StandaloneChoiceList extends xa_ChoiceList
{
    /** Constant value used for the 'standalone' keyword. */
    public final static String STANDALONE_STRING = "standalone";

    // Allowed values.
    public final static String NO_STRING         = "no";
    public final static String YES_STRING        = "yes";

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xa_StandaloneChoiceList()
    {
        super(STANDALONE_STRING);
        init();
    }

    //*****************************************************************************
    /**
     * Initialise the list of allowed values.
     */
    protected void init()
    {
        addChoice(NO_STRING,  0);
        addChoice(YES_STRING, 1);
    }
}

//*****************************************************************************
