//*****************************************************************************
/*
** FILE:   xa_NodeTypeChoiceList.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    07Jun98  stevew  Created.
**    23Jul98  stevew  Modified to reflect changes in DOM Version 1.0.
*/
package xa;

//import org.w3c.dom.Node;

//*****************************************************************************
/** <p>A list of the values allowed for a node type. The constant values for
 *  the node types listed here are compatible with DOM, although it should be
 *  noted that:</p>
 *
 *  <p>1. The names of the constants used here differ from the DOM constants
 *        in org.w3c.dom.Node.</p>
 *
 *  <p>2. Extra node types are defined, for DTD entities.</p>
 *
 *  <p>3. The DOM attribute node type is not used.</p>
 */
public class xa_NodeTypeChoiceList extends xa_ChoiceList
{
    /** Constant value used for the name of this list - though this is not
     *  itself an XML keyword. */
    public final static String NODE_TYPE_STRING = "node_type";

    // Allowed values.
    public final static String DOCUMENT_STRING          = "Document";
    public final static String ELEMENT_STRING           = "Element";
    public final static String ATTRIBUTE_STRING         = "Attribute";
    public final static String PI_STRING                = "PI";
    public final static String COMMENT_STRING           = "Comment";
    public final static String TEXT_STRING              = "Text";
    public final static String CDATA_STRING             = "CData";
    public final static String DOCUMENT_FRAGMENT_STRING = "Document fragment";
    public final static String ENTITY_STRING            = "Entity";
    public final static String REFERENCE_STRING         = "Entity reference";
    public final static String DOCTYPE_DECL_STRING      = "Document type declaration";
    // The remaining types are not defined in the DOM.
    public final static String EXTERNAL_ID_STRING       = "Notation declaration";
    public final static String XML_DECL_STRING          = "XML declaration";
    public final static String NAMESPACE_DECL_STRING    = "Namespace declaration";
    public final static String ATTLIST_DECL_STRING      = "Att list declaration";
    public final static String ATT_DECL_STRING          = "Attribute declaration";
    public final static String ENTITY_DECL_STRING       = "Entity declaration";
    public final static String ELEMENT_DECL_STRING      = "Element declaration";
    public final static String NOTATION_DECL_STRING     = "Notation declaration";

    public static final int    DOCUMENT_TYPE          =  1;
    public static final int    ELEMENT_TYPE           =  2;
    public static final int    ATTRIBUTE_TYPE         =  3;
    public static final int    PI_TYPE                =  4;
    public static final int    COMMENT_TYPE           =  5;
    public static final int    TEXT_TYPE              =  6;
    public static final int    CDATA_TYPE             =  7;
    public static final int    DOCUMENT_FRAGMENT_TYPE =  8;
    public static final int    ENTITY_TYPE            =  9;
    public static final int    REFERENCE_TYPE         = 10;
    public static final int    DOCTYPE_DECL_TYPE      = 11;
    // The remaining types are not defined in the DOM.
    public static final int    EXTERNAL_ID_TYPE       = 12;
    public static final int    XML_DECL_TYPE          = 13;
    public static final int    NAMESPACE_DECL_TYPE    = 14;
    public static final int    ATTLIST_DECL_TYPE      = 15;
    public static final int    ATT_DECL_TYPE          = 16;
    public static final int    ENTITY_DECL_TYPE       = 17;
    public static final int    ELEMENT_DECL_TYPE      = 18;
    public static final int    NOTATION_DECL_TYPE     = 19;

    //*****************************************************************************
    /** Default constructor.
     */
    public xa_NodeTypeChoiceList()
    {
        super(NODE_TYPE_STRING);
        init();
    }

    //*****************************************************************************
    /** Initialise the list of allowed values.
     */
    protected void init()
    {
        addChoice(DOCUMENT_STRING,          DOCUMENT_TYPE);
        addChoice(ELEMENT_STRING,           ELEMENT_TYPE);
        addChoice(ATTRIBUTE_STRING,         ATTRIBUTE_TYPE);
        addChoice(PI_STRING,                PI_TYPE);
        addChoice(COMMENT_STRING,           COMMENT_TYPE);
        addChoice(TEXT_STRING,              TEXT_TYPE);
        addChoice(CDATA_STRING,             CDATA_TYPE);
        addChoice(DOCUMENT_FRAGMENT_STRING, DOCUMENT_FRAGMENT_TYPE);
        addChoice(ENTITY_STRING,            ENTITY_TYPE);
        addChoice(REFERENCE_STRING,         REFERENCE_TYPE);
        addChoice(DOCTYPE_DECL_STRING,      DOCTYPE_DECL_TYPE);
        addChoice(EXTERNAL_ID_STRING,       EXTERNAL_ID_TYPE);
        addChoice(XML_DECL_STRING,          XML_DECL_TYPE);
        addChoice(NAMESPACE_DECL_STRING,    NAMESPACE_DECL_TYPE);
        addChoice(ATTLIST_DECL_STRING,      ATTLIST_DECL_TYPE);
        addChoice(ATT_DECL_STRING,          ATT_DECL_TYPE);
        addChoice(ENTITY_DECL_STRING,       ENTITY_DECL_TYPE);
        addChoice(ELEMENT_DECL_STRING,      ELEMENT_DECL_TYPE);
        addChoice(NOTATION_DECL_STRING,     NOTATION_DECL_TYPE);
    }
}

//*****************************************************************************
