//*****************************************************************************
/*
** FILE:   xa_Keyword.java
**
** (c) 1997, 1998 Steve Withall.
**
** HISTORY:
**    02Nov97  stevew  Created.
**    21Apr98  stevew  Moved from package xg to xa.
*/
package xa;

//*****************************************************************************
/** A utility class which defines constant string values for standard XML
 *  keywords.
 *
 *  It is expected that this class will normally be used statically: that
 *  instances will typically not be created.
 */
public class xa_Keyword
{
    /** Constants for the standard XML keywords. */
    public final static int    DOUBLE_QUOTE_CHAR          = '\"'; // (34)
    public final static int    HASH_CHAR                  = '#';  // (35)
//    public final static String FIXED_STRING               = "#FIXED";
//    public final static String IMPLIED_STRING             = "#IMPLIED";
    public final static String PCDATA_STRING              = "PCDATA";
//    public final static String REQUIRED_STRING            = "#REQUIRED";
    public final static int    PERCENT_CHAR               = '%';  // (37)
    public final static int    AMPERSAND_CHAR             = '&';  // (38)
    public final static String CHAR_REFERENCE_DEC_STRING  = "&#";
    public final static String CHAR_REFERENCE_HEX_STRING  = "&#";
    public final static int    SINGLE_QUOTE_CHAR          = '\''; // (39)
    public final static int    OPEN_PAREN_CHAR            = '(';  // (40)
    public final static int    CLOSE_PAREN_CHAR           = ')';  // (41)
    public final static int    STAR_CHAR                  = '*';  // (42)
    public final static int    PLUS_CHAR                  = '+';  // (43)
    public final static int    COMMA_CHAR                 = ',';  // (44)
    public final static int    DASH_CHAR                  = '-';  // (45)
    public final static String COMMENT_END_STRING         = "-->";
    public final static int    SLASH_CHAR                 = '/';  // (47)
    public final static String EMPTY_TAG_END_STRING       = "/>";
    public final static int    COLON_CHAR                 = ':';  // (58)
    public final static int    TAG_START_CHAR             = '<';  // (60)
    public final static String COMMENT_START_STRING       = "<!--";
    public final static String CDATA_START_STRING         = "<![CDATA[";
    public final static String ATTLIST_DECL_START_STRING  = "<!ATTLIST";
    public final static String DOCTYPE_START_STRING       = "<!DOCTYPE";
    public final static String ELEMENT_DECL_START_STRING  = "<!ELEMENT";
    public final static String ENTITY_DECL_START_STRING   = "<!ENTITY";
    public final static String NOTATION_DECL_START_STRING = "<!NOTATION";
    public final static String END_TAG_START_STRING       = "</";
    public final static String PI_START_STRING            = "<?";
    public final static int    EQUALS_CHAR                = '=';  // (61)
    public final static int    TAG_END_CHAR               = '>';  // (62)
    public final static int    QUESTION_MARK_CHAR         = '?';  // (63)
    public final static String PI_END_STRING              = "?>";
    public final static int    OPEN_BRACKET_CHAR          = '[';  // (91)
    public final static int    CLOSE_BRACKET_CHAR         = ']';  // (93)
    public final static String CDATA_END_STRING           = "]]>";
    public final static int    OR_CHAR                    = '|';  // (124)
    public final static String ANY_STRING                 = "ANY";
    public final static String EMPTY_STRING               = "EMPTY";
    public final static String ENCODING_STRING            = "encoding";
    public final static String IGNORE_STRING              = "IGNORE";
    public final static String INCLUDE_STRING             = "INCLUDE";
    public final static String NDATA_STRING               = "NDATA";
    public final static String PUBLIC_STRING              = "PUBLIC";
    public final static String SYSTEM_STRING              = "SYSTEM";
    public final static String VERSION_STRING             = "version";
    public final static String XML_STRING                 = "xml";
}

//*****************************************************************************
