//*****************************************************************************
/*
** FILE:   xa_CharChecker.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    08Jul98  stevew  Created.
*/
package xa;

//*****************************************************************************
/** A utility class offering a range of static checking functions on supplied
 *  characters or strings - to tell whether a given character is whitespace, or
 *  valid in an XML name, and such like.</p>
 */
public class xa_CharChecker
{
    //*****************************************************************************
    /** Is the given string composed entirely of whitespace?
     *
     *  @param  InputString  The string to be checked to see if it whitespace
     *  @return              true if InputString is whitespace; false if not
     */
    static public boolean isWhitespace(String  InputString)
    {
        boolean  WhitespaceFlag = true;
        char     CurrentChar;
        for (int CharIndex = 0; CharIndex < InputString.length(); CharIndex++)
        {
            CurrentChar = InputString.charAt(CharIndex);
            if (!isWhitespace(CurrentChar) )
            {
                WhitespaceFlag = false;
                break;
            }
        }

        return WhitespaceFlag;
    }

    //*****************************************************************************
    /** Is the given character whitespace?
     *
     *  @param  InputChar  The character to be checked to see if it whitespace
     *  @return            true if InputChar is whitespace; false if not
     */
    static public boolean isWhitespace(char  InputChar)
    {
        boolean  WhitespaceFlag = false;
        if (    (InputChar == ' ')            // #x0020
             || (InputChar == '\u0009')
             || (InputChar == '\r')           // #x000D
             || (InputChar == '\n')           // #x000A
             || (InputChar == '\u3000') )
            WhitespaceFlag = true;

        return WhitespaceFlag;
    }

    //*****************************************************************************
    /** Indicates if the current character is valid in an XML number.
     *
     *  @param  InputChar  The character to be checked to see if it is a number
     *  @return            true if InputChar is a number; false if not
     */
    static public boolean haveNumberChar(char  InputChar)
    {
        return Character.isDigit(InputChar);
    }

    //*****************************************************************************
    /** Indicates if the given character is a valid hexadecimal digit.
     *
     *  @param  InputChar  The character to be checked to see if it is a number
     *  @return            true if InputChar is a hex digit; false if not
     */
    static public boolean haveHexNumberChar(char  InputChar)
    {
        return(    (InputChar >= '0' && InputChar <='9')
                || (InputChar >= 'a' && InputChar <='f')
                || (InputChar >= 'A' && InputChar <='F') );
    }

    //*****************************************************************************
    /** Indicates if the given character is valid for the start of a name.
     *
     *  @param  InputChar  The character to be checked
     *  @return            true if InputChar is valid at the start of a name
     */
    static public boolean haveNameStartChar(char  InputChar)
    {
        return(    (Character.isLetter(InputChar))
                || (InputChar == '_')
                || (InputChar == ':')              );
    }

    //*****************************************************************************
    /** Indicates if the given character is valid for inclusion in a name.
     *
     *  @param  InputChar  The character to be checked
     *  @return            true if InputChar is valid in a name
     */
    static public boolean haveNameChar(char  InputChar)
    {
        return(Character.isUnicodeIdentifierPart(InputChar)
                || (InputChar == '.')
                || (InputChar == '-')
                || (InputChar == ':')                      );
    }

    //*****************************************************************************
    /** Indicates if the given character is valid in PCData.
     *
     *  @param  InputChar  The character to be checked
     *  @return            true if InputChar is valid in a name
     */
    static public boolean havePCDataChar(char  InputChar)
    {
        return(    (InputChar != '&')
                && (InputChar != '<')
                && (InputChar != '^') );
    }
}

//*****************************************************************************
