//*****************************************************************************
/*
** FILE:   xa_AttTypeChoiceList.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    21Apr98  stevew  Created.
*/
package xa;

//*****************************************************************************
/**
*  <p>Class xa_AttTypeChoiceList - A list of the values allowed for the type of
*  an attribute type.</p>
*/
public class xa_AttTypeChoiceList extends xa_ChoiceList
{
    public final static String ATT_TYPE_STRING  = "attribute_type";
    /** Constant value used for the name of this list - though this is not
     *  itself an XML keyword. */

    // Allowed values.
    public final static String NOTATION_STRING  = "NOTATION";
    public final static String CDATA_STRING     = "CDATA";
    public final static String ID_STRING        = "ID";
    public final static String IDREF_STRING     = "IDREF";
    public final static String IDREFS_STRING    = "IDREFS";
    public final static String ENTITY_STRING    = "ENTITY";
    public final static String ENTITIES_STRING  = "ENTITIES";
    public final static String NMTOKEN_STRING   = "NMTOKEN";
    public final static String NMTOKENS_STRING  = "NMTOKEN";

    public final static int    NOTATION_TYPE    =  0;  // Enumerated
    public final static int    CDATA_TYPE       =  1;  // String
    public final static int    ID_TYPE          =  2;  // Tokenized
    public final static int    IDREF_TYPE       =  3;  // Tokenized
    public final static int    IDREFS_TYPE      =  4;  // Tokenized
    public final static int    ENTITY_TYPE      =  5;  // Tokenized
    public final static int    ENTITIES_TYPE    =  6;  // Tokenized
    public final static int    NMTOKEN_TYPE     =  7;  // Tokenized
    public final static int    NMTOKENS_TYPE    =  8;  // Tokenized

    //*****************************************************************************
    /**
     * Default constructor.
     */
    public xa_AttTypeChoiceList()
    {
        super(ATT_TYPE_STRING);
        init();
    }

    //*****************************************************************************
    /**
     * Initialise the list of allowed values.
     */
    protected void init()
    {
        addChoice(NOTATION_STRING, NOTATION_TYPE);
        addChoice(CDATA_STRING,    CDATA_TYPE);
        addChoice(ID_STRING,       ID_TYPE);
        addChoice(IDREF_STRING,    IDREF_TYPE);
        addChoice(IDREFS_STRING,   IDREFS_TYPE);
        addChoice(ENTITY_STRING,   ENTITY_TYPE);
        addChoice(ENTITIES_STRING, ENTITIES_TYPE);
        addChoice(NMTOKEN_STRING,  NMTOKEN_TYPE);
        addChoice(NMTOKENS_STRING, NMTOKENS_TYPE);
    }
}

//*****************************************************************************
