//*****************************************************************************
/*
** FILE:   oh_HelpAction.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    30Jul98  stevew  Created, based on xu_LookAndFeelAction.
*/
package oh;

import xu.xu_MenuItem;

import xg.xg_AttList;

import eh.eh_Debug;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JFrame;

import java.awt.event.ActionEvent;

//*****************************************************************************
/** An action which invokes an HTML help frame, obtaining information about the
 *  page to display from the attributes associated with the menu item which
 *  invoked it (if it was invoked from an xu_MenuItem, that is).
 */
public class oh_HelpAction extends AbstractAction
{
    /** This action's parent frame, to be passed to the help frame we create. */
    protected JFrame            ParentFrame  = null;

    /** The help frame itself. Note that the same frame is re-used for all
     *  calls. */
//    protected oh_HtmlHelpFrame  TheHelpFrame = null;

    //*****************************************************************************
    /** Constructor.
     *
     *  @param InputActionName  The name of the action
     */
    public oh_HelpAction(JFrame  InputParentFrame)
    {
    	super("help");
        ParentFrame = InputParentFrame;
    }

    //*****************************************************************************
    /** We have been invoked!
     */
    public void actionPerformed(ActionEvent  InputActionEvent)
    {
        Object  SourceObject = InputActionEvent.getSource();
        if (SourceObject instanceof xu_MenuItem)
            actionFromMenuItem((xu_MenuItem)SourceObject);
        else
            eh_Debug.add(2, "oh_HelpAction.actionPerformed: Not invoked from an xu_MenuItem,"
                                  + " so cannot obtain attribute list required");
    }

    //*****************************************************************************
    /** We have been invoked from an xu_MenuItem.
     */
    public void actionFromMenuItem(xu_MenuItem  InputMenuItem)
    {
        xg_AttList  MenuItemAttList = InputMenuItem.getAttList();

        String      HelpFrameTitle  = MenuItemAttList.getAttributeValue("Label");
        //TBD Add error handling
        String      HelpFileUrl     = MenuItemAttList.getAttributeValue("Href");
        //TBD Add error handling

        new oh_HtmlHelpFrame(ParentFrame, HelpFrameTitle, HelpFileUrl);
    }
}

//*****************************************************************************
