//*****************************************************************************
/*
** FILE:   eh_ListSystemPropertiesAction.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    29Jul98  stevew  Created.
*/
package eh;

import com.sun.java.swing.AbstractAction;

import java.awt.event.ActionEvent;

import java.util.Enumeration;
import java.util.Properties;

//*****************************************************************************
/** List the Java system properties to debug.
 */
public class eh_ListSystemPropertiesAction extends AbstractAction
{
    //*****************************************************************************
   	public eh_ListSystemPropertiesAction()
   	{
   	    super("list-system-properties");
  	}

    //*****************************************************************************
    public void actionPerformed(ActionEvent  InputActionEvent)
    {
        Properties SystemProperties = System.getProperties();

        eh_Debug.add(3, "The system properties are:");
        eh_Debug.incrementIndentLevel();
        Enumeration  PropertyNameEnumeration = SystemProperties.keys();
	    while (PropertyNameEnumeration.hasMoreElements() )
	    {
		    String CurrentPropertyName  = (String)PropertyNameEnumeration.nextElement();
		    String CurrentPropertyValue = SystemProperties.getProperty(CurrentPropertyName);
            eh_Debug.add(3, new String(CurrentPropertyName + " = " + CurrentPropertyValue) );
        }
        eh_Debug.decrementIndentLevel();
    }
}

//*****************************************************************************
