//*****************************************************************************
/*
** FILE:   eh_DebugThread.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    19Mar98  stevew  Created.
*/
package eh;

//*****************************************************************************
/**
 * Class eh_DebugThread - a thread for moving pending debug output to the
 * screen after a pre-determined delay.
 */
public class eh_DebugThread extends Thread
{
	eh_DebugListModel      DebugListModel = null;
	/** Manager for the output of debug information to the screen. It holds the
	 *  buffered pending output and the document to which it needs to be moved. */

    protected int          DisplayUpdateInterval = 1000;
    /** The length of time to wait before updating the document (in milliseconds). */

    protected static int   ThreadNum = 1;

    //*****************************************************************************
    /**
     * Constructor. Create a new thread for recording debug output.
     */
    public eh_DebugThread()
    {
        super("Debug" + ThreadNum++);
//        super("eh_DebugThread" + ThreadNum++);
    	setPriority(Thread.MIN_PRIORITY);
    }

    //*****************************************************************************
    // Start the thread.
    //
    public void run()
    {
        try
        {
  	        sleep(DisplayUpdateInterval);        // Wait

//            int CurrentTime = (int)System.currentTimeMillis();      //TEMP
//  	        System.err.println(getName() + ": eh_DebugThread.run activated at: "
//    	                                 + CurrentTime);                //TEMP

            DebugListModel.refreshScreen();  // Move buffered output to screen
        }
        catch (InterruptedException InputException)
        {
  	        System.err.println(getName() + ": eh_DebugThread.run has been interrupted: "
    	                             + InputException);
        }
    }

    //*****************************************************************************
    /**
     *  Set the debug list model.
     */
    public void setDebugListModel(eh_DebugListModel  InputDebugListModel)
    {
	    DebugListModel = InputDebugListModel;
    }

    //*****************************************************************************
    /**
     *  Set the time to wait before displaying new output.
     */
    public void setDisplayUpdateInterval(int  InputDisplayUpdateInterval)
    {
	    DisplayUpdateInterval = InputDisplayUpdateInterval;
    }
}

//*****************************************************************************
