//*****************************************************************************
/*
** FILE:   eh_DebugPrefsDialog.java
**
** Copyright 1997, 1998 Steve Withall.
**
** HISTORY:
**    14Sep97  stevew  Created.
**    22Apr98  stevew  Switched to Swing.
*/
package eh;

import com.sun.java.swing.Box;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTextField;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;

//*****************************************************************************
/**
 * Pop up a (modal) message dialog and wait for a user to press "Cancel"
 * or "Update".
 */
public class eh_DebugPrefsDialog extends JDialog
{
    // Attributes relating to the maximum number of debug lines which
    // may be present in an on-screen debug list box. (Once this limit
    // has been reached, lines are removed from the start of the list.)
    JLabel      MaxCharsLabel     = new JLabel("List box maximum number of characters");
	JTextField  MaxCharsTextField = new JTextField(4);

    // Attributes relating to the current debug level for the on-screen
    // list box.
    JLabel      ListBoxDebugLevelLabel     = new JLabel("List box debug level");
	JTextField  ListBoxDebugLevelTextField = new JTextField(2);
    JLabel      ListBoxDebugLevelLabel2    = new JLabel("(0=None, 9=Maximum)");

    // Attributes relating to the name of the debug file.
    JLabel      FileNameLabel     = new JLabel("Debug output file name");
    JTextField  FileNameTextField = new JTextField(30);

    // Attributes relating to the current debug level for the debug log
    // file.
    JLabel      FileDebugLevelLabel     = new JLabel("Debug output file debug level");
    JTextField  FileDebugLevelTextField = new JTextField(2);
    JLabel      FileDebugLevelLabel2    = new JLabel("(0=None, 9=Maximum)");

    // Buttons.
    JButton     UpdateButton = new JButton("Update");
    JButton     CancelButton = new JButton("Cancel");

    //*****************************************************************************
    /**
     * Constructor.
     */
    public eh_DebugPrefsDialog(Frame  InputParentFrame)
    {
	    super(InputParentFrame, "Debug preferences", true);

	    // Load icon image.
//	    Image  IconImage   = Toolkit.getDefaultToolkit().getImage("eh/images/eh_DebugIcon.gif");
//	    InputParentFrame.setIconImage(IconImage);

        GridBagLayout      gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        getContentPane().setLayout(gbl);

        // List box max lines.
        gbc.anchor    = GridBagConstraints.WEST;
        gbc.gridwidth = 1;
        gbc.insets    = new Insets(0, 4, 8, 4);
        gbl.setConstraints(MaxCharsLabel, gbc);
        getContentPane().add(MaxCharsLabel);

        int MaxChars = eh_Debug.getDebugBoxMaxChars();
        MaxCharsTextField.setText(Integer.toString(MaxChars));
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(MaxCharsTextField, gbc);
        getContentPane().add(MaxCharsTextField);

        // List box debug level.
        gbc.gridwidth = 1;
        gbl.setConstraints(ListBoxDebugLevelLabel, gbc);
        getContentPane().add(ListBoxDebugLevelLabel);

        int ListBoxDebugLevel = eh_Debug.getDebugBoxImportanceLevel();
        ListBoxDebugLevelTextField.setText(Integer.toString(ListBoxDebugLevel));
        gbl.setConstraints(ListBoxDebugLevelTextField, gbc);
        getContentPane().add(ListBoxDebugLevelTextField);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(ListBoxDebugLevelLabel2, gbc);
        getContentPane().add(ListBoxDebugLevelLabel2);

        // File name.
        gbc.gridwidth = 1;
        gbl.setConstraints(FileNameLabel, gbc);
        getContentPane().add(FileNameLabel);

        String FileNameString = eh_Debug.getDebugFileName();
        FileNameTextField.setText(FileNameString);
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(FileNameTextField, gbc);
        getContentPane().add(FileNameTextField);

        // File debug level.
        gbc.gridwidth = 1;
        gbl.setConstraints(FileDebugLevelLabel, gbc);
        getContentPane().add(FileDebugLevelLabel);

        int FileDebugLevel = eh_Debug.getDebugFileImportanceLevel();
        FileDebugLevelTextField.setText(Integer.toString(FileDebugLevel));
        gbl.setConstraints(FileDebugLevelTextField, gbc);
        getContentPane().add(FileDebugLevelTextField);

        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbl.setConstraints(FileDebugLevelLabel2, gbc);
        getContentPane().add(FileDebugLevelLabel2);

	    // Panel for buttons.
        Box  ButtonBox = Box.createHorizontalBox();
        ButtonBox.add(UpdateButton);
        ButtonBox.add(CancelButton);

        gbc.anchor    = GridBagConstraints.EAST;
//        gbc.anchor    = GridBagConstraints.SOUTH;
        gbc.insets    = new Insets(5, 0, 0, 0);
        gbc.fill      = GridBagConstraints.HORIZONTAL;
//        gbc.gridwidth = 1;  // The number of horizontal cells  //TEMP
        gbl.setConstraints(ButtonBox, gbc);
        getContentPane().add(ButtonBox);

    	UpdateButton.addActionListener(new UpdateButtonListener() );
    	CancelButton.addActionListener(new CancelButtonListener() );

        Point  ParentLocation = InputParentFrame.getLocation();
        setBounds(ParentLocation.x + 40, ParentLocation.y + 110, 600, 180);
        show();
    }

    //*****************************************************************************
    // Button listener inner classes.
    //*****************************************************************************
    /**
     * Handle pressing of the "Update" button. Change the eh_Debug static values
     * and then close this dialog.
     */
    class UpdateButtonListener implements ActionListener
    {
        public void actionPerformed(ActionEvent  InputEvent)
        {
            try
            {
                // List box max lines.
                String  MaxCharsString = MaxCharsTextField.getText();
                int     MaxChars       = Integer.parseInt(MaxCharsString);
                eh_Debug.setDebugBoxMaxChars(MaxChars);

                // List box debug level.
                String  ListBoxDebugLevelString = ListBoxDebugLevelTextField.getText();
                int     ListBoxDebugLevel       = Integer.parseInt(ListBoxDebugLevelString);
                eh_Debug.setDebugBoxImportanceLevel(ListBoxDebugLevel);

                // File name.
                String  FileNameString = FileNameTextField.getText();
                eh_Debug.setDebugFileName(FileNameString);

                // File debug level.
                String  FileDebugLevelString = FileDebugLevelTextField.getText();
                int     FileDebugLevel       = Integer.parseInt(FileDebugLevelString);
                eh_Debug.setDebugFileImportanceLevel(FileDebugLevel);
            }
            catch (java.lang.NumberFormatException InputException)
            {
//                MessageDialog ErrorMessageDialog
//                                = new MessageDialog(Util.getFrame(this),
//                                                    this,
//                                                    "Number error",
//                                                    "A non-numeric value has been entered in a number field",
//                                                    null,
//                                                    true);
//                ErrorMessageDialog.setVisible(true);
	            eh_Debug.add(1, "A non-numeric value has been entered in a number field");
                return;
            }

            dispose();
        }
    }

    //*****************************************************************************
    /**
     * Handle pressing of the "Cancel" button. Close this dialog, and do nothing
     * else.
     */
    class CancelButtonListener implements ActionListener
    {
        public void actionPerformed(ActionEvent  InputEvent)
        {
            dispose();
        }
    }
}
//*****************************************************************************
