//*****************************************************************************
/*
** FILE:   eh_DebugFrame.java
**
** (c) 1997, 1998 Steve Withall.
**
** HISTORY:
**    14Sep97  stevew  Created.
**    04Apr98  stevew  Switched to Swing.
*/
package eh;

import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.PlainDocument;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;

//*****************************************************************************
/** eh_DebugFrame acts as the top-level "frame" that contains a List.
 */
public class eh_DebugFrame extends JFrame implements LayoutManager
{
    /** List box in which all debug output is displayed. */
    JTextArea          MessageList;

    JScrollPane        MessageScrollPane;

    eh_DebugListModel  DebugListModel = new eh_DebugListModel();

    /** The size and location of this frame. */
    Rectangle          DebugWindowBounds;

    //*****************************************************************************
    /** Default constructor. Create a new eh_DebugFrame at a default screen location.
     */
    public eh_DebugFrame()
    {
        super("Debug");

        // Get details of the screen size.
        Toolkit    DefaultToolkit = Toolkit.getDefaultToolkit();
        Dimension  ScreenSize     = DefaultToolkit.getScreenSize();

        DebugWindowBounds = new Rectangle(35,
                                          ScreenSize.height / 2,
                                          ScreenSize.width - 35,
                                          (ScreenSize.height / 2) - 27);
        init();
    }

    //*****************************************************************************
    /** Constructor, creating a new eh_DebugFrame of a specified size and location.
     */
    public eh_DebugFrame(Rectangle  InputDebugWindowBounds)
    {
        super("Debug");
        DebugWindowBounds = InputDebugWindowBounds;
        init();
    }

    //*****************************************************************************
    /** Constructor. Create a new eh_DebugFrame at a default screen location.
     */
    protected void init()
    {
	    // Load icon image.
	    Image  IconImage = Toolkit.getDefaultToolkit().getImage("config/eh/images/eh_DebugIcon.gif");
	    setIconImage(IconImage);

	    getContentPane().setLayout(new BorderLayout() );
        setFont(new Font("Monospaced", Font.PLAIN, 12));

	    // Create the debug message JTextArea.
	    MessageList = new JTextArea();
	    MessageList.setFont(new Font("Courier", Font.PLAIN, 12));
	    MessageList.setTabSize(4);
	    MessageList.setDocument(DebugListModel.getDebugDocument() );
	    MessageList.setBorder(null);
	    MessageList.setEditable(false);

	    eh_Debug.setDebugListModel(DebugListModel);

	    MessageScrollPane = new JScrollPane(MessageList);
	    getContentPane().add("Center", MessageScrollPane);

        try
        {
            DebugListModel.getDebugDocument().insertString(0, "Ready to go!", null);
        }
    	catch (BadLocationException InputException)
    	{
//            eh_Debug.Add(2, "Location of error string is bad. Exception = " + InputException);
    	}

	    setBounds(DebugWindowBounds);
	    show();
    }

    //*****************************************************************************
    /** Destroy this frame.
     */
    public void dispose()
    {
        super.dispose();
        DebugListModel = null;
    }

    //*****************************************************************************
    public JTextArea getMessageList()
    {
	    return MessageList;
    }

    //*****************************************************************************
    //*Layout-related*methods******************************************************
    //*****************************************************************************
    public void addLayoutComponent(String name, Component comp)
    {
    }

    //*****************************************************************************
    public void removeLayoutComponent(Component comp)
    {
    }

    //*****************************************************************************
    public Dimension preferredLayoutSize(Container parent)
    {
	    return new Dimension(500, 300);
    }

    //*****************************************************************************
    public Dimension minimumLayoutSize(Container parent)
    {
        return new Dimension(100, 100);
    }

    //*****************************************************************************
    public void layoutContainer(Container parent)
    {
    }
}
//*****************************************************************************
