//*****************************************************************************
/*
** FILE:   eh_DebugBoxAction.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    29Jul98  stevew  Created.
*/
package eh;

import xu.xu_CheckBoxAction;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.JFrame;

import java.awt.event.ActionEvent;

//*****************************************************************************
/** Toggle display of the debug output box.
 */
public class eh_DebugBoxAction extends xu_CheckBoxAction
{
	/** The debug output frame. */
	static eh_DebugFrame  TheDebugFrame = null;

    //*****************************************************************************
  	public eh_DebugBoxAction()
   	{
   	    super("debug-box");
   	}

    //*****************************************************************************
    public void actionPerformed(ActionEvent  InputActionEvent)
    {
        super.actionPerformed(InputActionEvent);
        conformToState();
    }

    //*****************************************************************************
    /** Take whatever steps are necessary to bring the Action into line with what
     *  the controlling check box wishes (as indicated by the value of StateFlag).
     *  This method may be called either when the associated menu item is selected
     *  (ie. called by actionPerformed) or during initialization.
     */
    public void conformToState()
    {
        if (StateFlag)
            // We want the debug box displayed
            createDebugFrame();
        else
            // We don't want the debug box displayed
            removeDebugFrame();
    }

    //*****************************************************************************
    /** Create the debug frame - if it does not exist.
     */
    public void createDebugFrame()
    {
        if (TheDebugFrame == null)
            TheDebugFrame = new eh_DebugFrame();
    }

    //*****************************************************************************
    /** Remove the debug frame - if it exists.
     */
    public void removeDebugFrame()
    {
        if (TheDebugFrame != null)
        {
            TheDebugFrame.dispose();    // Kill the debug frame
            TheDebugFrame = null;
        }
    }

    //*****************************************************************************
    /** Get the debug frame - or null if it does not exist.
     *
     *  @return  The debug frame itself.
     */
    public eh_DebugFrame getDebugFrame()
    {
        return TheDebugFrame;
    }
}

//*****************************************************************************
