//*****************************************************************************
/*
** FILE:   da_ViewColumnElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    30May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of one column in a database view.
*/
public class da_ViewColumnElement extends xg_Element
{
    /** The name of this column. */
    protected String           ColumnName           = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName       = "ViewColumn";

    /** The name of the attribute which holds the name of this column. */
    public final static String NameAttName          = "Name";

    /** The name of the table this column comes from. */
    public final static String TableNameAttName     = "TableName";

    //*****************************************************************************
    /** Construct a view column element with no name.
     */
    public da_ViewColumnElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a view column element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_ViewColumnElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Name' attribute.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "da_ViewColumnElement.verify:");
        ColumnName = getAttributeValue(NameAttName);
        if (ColumnName == null)
            throw new xg_VerificationException("Database view column does not contain a '"
                                                   + NameAttName + "' attribute",
                                               getStartOffset(),
                                               getEndOffset() );
    }

    //*****************************************************************************
    /** Analyse the definition of the column whose details are in the
     *  InputColumnResultSet, and model it here.
     *
     *  @param InputMetaData         the metadata describing the database to which
     *                                this column belongs
     *  @param InputColumnResultSet  the result set from which to obtain details
     *                                about the column we represent
     */
    public void analyseColumn(DatabaseMetaData  InputMetaData,
    	                      ResultSet         InputColumnResultSet)
    {
        try
        {
  	        ColumnName = InputColumnResultSet.getString(4);
  	        addAttribute(NameAttName, ColumnName);
	        eh_Debug.add(6, "da_ViewColumnElement.analyseColumn: Column '"
                                                            + ColumnName + "'");
   	        String TableName = InputColumnResultSet.getString(3);
  	        addAttribute(TableNameAttName, TableName);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving view column details: " + InputException);
        }
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("View column '" + ColumnName + "'");
    }
}

//*****************************************************************************
