//*****************************************************************************
/*
** FILE:   da_IndexesElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of the indexes of a database
 *  table. Note that an "Indexes" element itself contains no information, and
 *  is just a container for the individual column elements (its children).
 */
public class da_IndexesElement extends xg_Element
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "Indexes";

    //*****************************************************************************
    /**
     * Construct a database table indexes element with no name.
     */
    public da_IndexesElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a database table indexes element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_IndexesElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or
     *  consistent with other nodes - such as its parent). The node is OK if it
     *  possesses a 'Class' attribute which names a valid database driver
     *  class.</p>
     *
     * @exception  Description of verification problem
     */
/*    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(2, "da_IndexesElement.verify: Verify '" + toString() + "'");

        // Obtain the menu item's ID from the "Class" attribute.
        String  DriverClassName = getAttributeValueVerified(ClassAttName);

        try
        {
            // Load the named driver class.
//            Class.forName(DriverClassName);
            Class  DriverClass = Class.forName(DriverClassName);
            eh_Debug.add(2, "da_IndexesElement.verify: Loaded driver '" + DriverClassName + "'");
        }
        catch (Exception InputException)
        {
            throw new xg_VerificationException("Error loading database driver '"
                                                  + DriverClassName + "': "
                                                  + InputException);
        }
    }
*/
    //*****************************************************************************
    /** Analyse the definition of the indexes whose details are in the
     *  InputIndexesResultSet, and model it here.
     *
     *  @param InputMetaData          the metadata describing the database to which
     *                                 this table belongs
     *  @param InputIndexesResultSet  the result set from which to obtain details
     *                                 about the indexes we represent
     */
    public void analyseIndexes(DatabaseMetaData  InputMetaData,
    	                       ResultSet         InputIndexesResultSet)
    {
	    eh_Debug.add(6, "da_IndexesElement.analyseIndexes:");
    	da_IndexElement  NewIndexElement   = null;
	    String           PreviousIndexName = null;

        try
        {
	        while (InputIndexesResultSet.next() )
    	    {
    	        String  IndexName = InputIndexesResultSet.getString(6);
    	        if (IndexName != null)
    	        {
    	            if (!(IndexName.equals(PreviousIndexName) ) )
    	            {
	                    eh_Debug.add(6, "Index '" + IndexName + "'");
    	                NewIndexElement = new da_IndexElement();
                        addChild(NewIndexElement);
                        NewIndexElement.setIndexName(IndexName);

    	                PreviousIndexName = IndexName;
    	            }

    	            NewIndexElement.addIndexColumn(InputIndexesResultSet);
    	        }

//    	        StringBuffer  DebugBuffer = new StringBuffer("  Index '" + IndexName + "'");
//    	        String  KeyColumnName = InputIndexesResultSet.getString(9);
//    	        DebugBuffer.append(", column '" + KeyColumnName + "'");
//	            eh_Debug.add(6, DebugBuffer.toString() );
	        }
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving list of indexes: " + InputException);
        }
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return("Database indexes element");
    }
}

//*****************************************************************************
