//*****************************************************************************
/*
** FILE:   da_IndexElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of one index of a database table.
*/
public class da_IndexElement extends xg_Element
{
    /** The name of this index. */
    protected String           IndexName      = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "Index";

    /** The name of the attribute which holds the name of this index. */
    public final static String NameAttName    = "Name";

    //*****************************************************************************
    /** Construct a database table indexes element with no name.
     */
    public da_IndexElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a database table indexes element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_IndexElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Name' attribute.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "da_IndexElement.verify:");
        IndexName = getAttributeValue(NameAttName);
        if (IndexName == null)
            throw new xg_VerificationException("Database index does not contain a '"
                                                   + NameAttName + "' attribute",
                                               getStartOffset(),
                                               getEndOffset() );
    }

    //*****************************************************************************
    /**
     * <p>Verify that this node is correct (ie. internally correct and/or consistent
     * with other nodes - such as its parent). The node is OK if it possesses a
     * 'Class' attribute which names a valid database driver class.</p>
     *
     * @exception  Description of verification problem
     */
/*    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(2, "da_IndexElement.verify: Verify '" + toString() + "'");

        // Obtain the menu item's ID from the "Class" attribute.
        String  DriverClassName = getAttributeValueVerified(ClassAttName);

        try
        {
            // Load the named driver class.
//            Class.forName(DriverClassName);
            Class  DriverClass = Class.forName(DriverClassName);
            eh_Debug.add(2, "da_IndexElement.verify: Loaded driver '" + DriverClassName + "'");
        }
        catch (Exception InputException)
        {
            throw new xg_VerificationException("Error loading database driver '"
                                                  + DriverClassName + "': "
                                                  + InputException);
        }
    }
*/
    //*****************************************************************************
    /** Set the name of this index.
     *
     *  @param  InputIndexName  the name of this index (which we assume has already
     *                           been read from InputIndexesResultSet)
     */
    public void setIndexName(String  InputIndexName)
    {
        IndexName = InputIndexName;
  	    addAttribute(NameAttName, InputIndexName);
	}

    //*****************************************************************************
    /** Add an column to this index, based on the InputIndexesResultSet.
     *
     *  @param  InputIndexesResultSet  the result set from which to obtain details
     *                                  about the index we represent
     */
    public void addIndexColumn(ResultSet  InputIndexesResultSet)
    {
	    eh_Debug.add(6, "da_IndexElement.addIndexColumn:");

  	    da_IndexColumnElement  NewIndexColumnElement = new da_IndexColumnElement();
        addChild(NewIndexColumnElement);
  	    NewIndexColumnElement.analyseIndexColumn(InputIndexesResultSet);
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return(NodeName + " '" + IndexName + "'");
    }
}

//*****************************************************************************
