//*****************************************************************************
/*
** FILE:   da_IndexColumnElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

//*****************************************************************************
/** An XML element to represent the structure of one column in the index of a
 * database table.
 */
public class da_IndexColumnElement extends xg_Element
{
    /** The name of this index column. */
    protected String           IndexColumnName     = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName      = "IndexColumn";

    /** The name of the attribute which holds the name of this column. */
    public final static String NameAttName         = "Name";

    /** The name of the attribute which holds the sort sequence of this column. */
    public final static String SortSequenceAttName = "Sequence";

    //*****************************************************************************
    /** Construct an index column element with no name.
     */
    public da_IndexColumnElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct an index column element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_IndexColumnElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Name' attribute.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "da_IndexColumnElement.verify:");
        IndexColumnName = getAttributeValue(NameAttName);
        if (IndexColumnName == null)
            throw new xg_VerificationException("Database index column does not contain a '"
                                                   + NameAttName + "' attribute",
                                               getStartOffset(),
                                               getEndOffset() );
    }

    //*****************************************************************************
    /** Set up this index column, based on the InputIndexesResultSet.
     *
     *  @param  InputIndexesResultSet  the result set from which to obtain details
     *                                  about the index column we represent
     */
    public void analyseIndexColumn(ResultSet  InputIndexesResultSet)
    {
	    eh_Debug.add(6, "da_IndexColumnElement.analyseIndexColumn:");

        try
        {
   	        IndexColumnName = InputIndexesResultSet.getString(9);
  	        addAttribute(NameAttName, IndexColumnName);
	        eh_Debug.add(6, "  Index column '" + IndexColumnName + "'");

   	        String  SortSequence = InputIndexesResultSet.getString(10);
  	        addAttribute(SortSequenceAttName, SortSequence);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving index details: " + InputException);
        }
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return(NodeName + " '" + IndexColumnName + "'");
    }
}

//*****************************************************************************
