//*****************************************************************************
/*
** FILE:   da_DatabaseViewElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    30May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of a database view.
 */
public class da_DatabaseViewElement extends xg_Element
{
    /** The name of this view. */
    protected String           ViewName       = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "DatabaseView";

    /** The name of the attribute which holds the name of this view. */
    public final static String NameAttName    = "Name";

    //*****************************************************************************
    /** Construct a database view element with no name.
     */
    public da_DatabaseViewElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a database view element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_DatabaseViewElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Class' attribute which names a valid database driver class.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "da_DatabaseViewElement.verify:");
        ViewName = getAttributeValue(NameAttName);
        if (ViewName == null)
            throw new xg_VerificationException("Database view does not contain a '"
                                                   + NameAttName + "' attribute",
                                               getStartOffset(),
                                               getEndOffset() );
    }

    //*****************************************************************************
    /** Analyse the definition of the view whose details are in the
     *  InputViewResultSet, and model it here.
     *
     *  @param InputMetaData       the metadata describing the database to which
     *                              this view belongs
     *  @param InputViewResultSet  the result set from which to obtain details
     *                              aboute name of this view
     */
    public void analyseView(DatabaseMetaData  InputMetaData,
    	                    ResultSet         InputViewResultSet)
    {
        try
        {
    	    ViewName                = InputViewResultSet.getString(3);
  	        addAttribute(NameAttName, ViewName);

    	    String  ViewCatalogName = InputViewResultSet.getString(1);
    	    String  ViewSchemaName  = InputViewResultSet.getString(2);
    	    String  ViewRemarks     = InputViewResultSet.getString(5);
    	    // String 4 in the result set is the view type - which we know is "VIEW".

    	    StringBuffer  DebugBuffer = new StringBuffer("View '" + ViewName + "'");
//          if (ViewCatalogName != null)
//              DebugBuffer.append(", in catalog '" + ViewCatalogName + "'");
//          if (ViewSchemaName != null)
//              DebugBuffer.append(", in schema '" + ViewSchemaName + "'");
    	    if (ViewRemarks != null)
    	        DebugBuffer.append(", remarks '" + ViewRemarks + "'");
	        eh_Debug.add(6, "da_DatabaseViewElement.analyseView: " + DebugBuffer.toString() );

            analyseColumns(InputMetaData);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving view details: " + InputException);
        }
    }

    //*****************************************************************************
    /** Find out about the columns in this view.
     */
    public void analyseColumns(DatabaseMetaData  InputMetaData)
    {
	    eh_Debug.add(6, "da_DatabaseViewElement.analyseColumns:");

        try
        {
	        // Get a list of all the columns in this view.
	        ResultSet  ColumnResultSet = InputMetaData.getColumns(null,
	                                                              null,
	                                                              ViewName,
	                                                              "%");
	        while (ColumnResultSet.next() )
    	    {
    	        da_ViewColumnElement  NewViewColumnElement = new da_ViewColumnElement();
                addChild(NewViewColumnElement);
    	        NewViewColumnElement.analyseColumn(InputMetaData, ColumnResultSet);
	        }
//    	    da_ColumnsElement  NewColumnsElement = new da_ColumnsElement();
//            addChild(NewColumnsElement);
//    	    NewColumnsElement.analyseColumns(InputMetaData, ColumnResultSet);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving list of columns: " + InputException);
        }
    }

    //*****************************************************************************
    /** Return a string representation of the element (intended for use as debug
     *  output).
     *
     *  @return  String representing the node's name.
     */
    public String toString()
    {
        return ("Database view '" + ViewName + "'");
    }
}

//*****************************************************************************
