//*****************************************************************************
/*
** FILE:   da_DatabaseTableElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of a database table.
 */
public class da_DatabaseTableElement extends xg_Element
{
    /** The name of this table. */
    protected String           TableName      = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "DatabaseTable";

    /** The name of the attribute which holds the name of this table. */
    public final static String NameAttName    = "Name";

    //*****************************************************************************
    /** Construct a database table element with no name.
     */
    public da_DatabaseTableElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a database table element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_DatabaseTableElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Name' attribute.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "da_DatabaseTableElement.verify:");
        TableName = getAttributeValue(NameAttName);
        if (TableName == null)
            throw new xg_VerificationException("Database table does not contain a '"
                                                   + NameAttName + "' attribute",
                                               getStartOffset(),
                                               getEndOffset() );
    }

    //*****************************************************************************
    /** Analyse the definition of the table whose details are in the
     *  InputTableResultSet, and model it here.
     *
     *  @param InputMetaData        the metadata describing the database to which
     *                               this table belongs
     *  @param InputTableResultSet  the result set from which to obtain details
     *                               abolute name of this table
     */
    public void analyseTable(DatabaseMetaData  InputMetaData,
    	                     ResultSet         InputTableResultSet)
    {
        try
        {
    	    TableName                = InputTableResultSet.getString(3);
  	        addAttribute(NameAttName, TableName);

    	    String  TableCatalogName = InputTableResultSet.getString(1);
    	    String  TableSchemaName  = InputTableResultSet.getString(2);
    	    String  TableRemarks     = InputTableResultSet.getString(5);
    	    // String 4 in the result set is the table type - which we know is "TABLE".

    	    StringBuffer  DebugBuffer = new StringBuffer("Table '" + TableName + "'");
//          if (TableCatalogName != null)
//              DebugBuffer.append(", in catalog '" + TableCatalogName + "'");
//          if (TableSchemaName != null)
//              DebugBuffer.append(", in schema '" + TableSchemaName + "'");
    	    if (TableRemarks != null)
    	        DebugBuffer.append(", remarks '" + TableRemarks + "'");
	        eh_Debug.add(6, "da_DatabaseTableElement.analyseTable: " + DebugBuffer.toString() );

            analyseColumns(InputMetaData);
            analyseIndexes(InputMetaData);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving table details: " + InputException);
        }
    }

    //*****************************************************************************
    /** Find out about the columns in this table.
     */
    public void analyseColumns(DatabaseMetaData  InputMetaData)
    {
	    eh_Debug.add(6, "da_DatabaseTableElement.analyseColumns:");

        try
        {
	        // Get a list of all the columns in this table.
	        ResultSet  ColumnResultSet = InputMetaData.getColumns(null,
	                                                              null,
	                                                              TableName,
	                                                              "%");
    	    da_ColumnsElement  NewColumnsElement = new da_ColumnsElement();
            addChild(NewColumnsElement);
    	    NewColumnsElement.analyseColumns(InputMetaData, ColumnResultSet);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving list of columns: " + InputException);
        }
    }

    //*****************************************************************************
    /** Find out about the indexes in this table.
     */
    public void analyseIndexes(DatabaseMetaData  InputMetaData)
    {
	    eh_Debug.add(6, "da_DatabaseTableElement.analyseIndexes:");

        try
        {
	        // Get a list of the columns which make up the primary index.
	        ResultSet  IndexResultSet = InputMetaData.getIndexInfo(null,
	                                                               null,
	                                                               TableName,
	                                                               false,
	                                                               true);
    	    da_IndexesElement  NewIndexesElement = new da_IndexesElement();
            addChild(NewIndexesElement);
    	    NewIndexesElement.analyseIndexes(InputMetaData, IndexResultSet);
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving list of views: " + InputException);
        }
    }

    //*****************************************************************************
    /** Return a string representation of the element (intended for use as debug
     *  output).
     *
     *  @return  String representing its name.
     */
    public String toString()
    {
        return ("Table '" + TableName + "'");
    }
}

//*****************************************************************************
