//*****************************************************************************
/*
** FILE:   da_DatabaseSchemaManager.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    09Jun98  stevew  Created, based on xu_FrameConfigManager.
*/
package da;

import xm.xm_NodeTypeRegistry;

//*****************************************************************************
/** Currently simply a means of registering the element classes used to
 *  represent the various parts of a database schema.
 */
public class da_DatabaseSchemaManager
//public class da_DatabaseSchemaManager extends xg_Document
{
    //*****************************************************************************
    /** Default constructor.
     */
//    public da_DatabaseSchemaManager()
//    {
//    }

    //*****************************************************************************
    /** <p>Register special types of element classes used for the various parts of
     *  a database schema.</p>
     *
     *  <p>The present approach isn't ideal: it's static, so affects <b>all</b> XML
     *  parsing, and it doesn't permit the unregistering of all the special
     *  registrations.</p>
     */
    static public void registerElementClasses()
    {
        xm_NodeTypeRegistry.setDefaultParserClassName("xe.xe_ElementParser");
        xm_NodeTypeRegistry.setDefaultCustomizerClassName("xc.xc_ElementCustomizer");
        xm_NodeTypeRegistry.setDefaultViewClassName("xv.xv_BoxViewX");

        xm_NodeTypeRegistry.register(da_DatabaseSchemaElement.RegisteredName,
                                                 "da.da_DatabaseSchemaElement");
        xm_NodeTypeRegistry.register(da_DatabaseTableElement.RegisteredName,
                                                 "da.da_DatabaseTableElement");
        xm_NodeTypeRegistry.register(da_ColumnsElement.RegisteredName,
                                                 "da.da_ColumnsElement");
        xm_NodeTypeRegistry.register(da_ColumnElement.RegisteredName,
                                                 "da.da_ColumnElement");
        xm_NodeTypeRegistry.register(da_IndexElement.RegisteredName,
                                                 "da.da_IndexElement");
        xm_NodeTypeRegistry.register(da_IndexColumnElement.RegisteredName,
                                                 "da.da_IndexColumnElement");
        xm_NodeTypeRegistry.register(da_DatabaseViewElement.RegisteredName,
                                                 "da.da_DatabaseViewElement");
        xm_NodeTypeRegistry.register(da_ViewColumnElement.RegisteredName,
                                                 "da.da_ViewColumnElement");
    }
}

//*****************************************************************************
