//*****************************************************************************
/*
** FILE:   da_ColumnsElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of the columns of a database
 *  table. Note that a "Columns" element itself contains no information, and is
 *  just a container for the individual column elements (its children).
 */
public class da_ColumnsElement extends xg_Element
{
    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName = "Columns";

    //*****************************************************************************
    /** Construct a database columns element with no name.
     */
    public da_ColumnsElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a database columns element with a name.
     *
     * @param  InputNodeName  The name of the element
     */
    public da_ColumnsElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** Analyse the definition of the columns whose details are in the
     *  InputColumnsResultSet, and model it here.
     *
     *  @param InputMetaData         the metadata describing the database to which
     *                                this table belongs
     *  @param InputColumnResultSet  the result set from which to obtain details
     *                                about the columns we represent
     */
    public void analyseColumns(DatabaseMetaData  InputMetaData,
    	                       ResultSet         InputColumnResultSet)
    {
	    eh_Debug.add(6, "da_ColumnsElement.analyseColumns:");

        try
        {
	        while (InputColumnResultSet.next() )
    	    {
    	        da_ColumnElement  NewColumnElement = new da_ColumnElement();
                addChild(NewColumnElement);
    	        NewColumnElement.analyseColumn(InputMetaData, InputColumnResultSet);
	        }
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving list of columns: " + InputException);
        }
    }

    //*****************************************************************************
    /** Return a string representation of the element (intended for use as debug
     *  output).
     *
     *  @return  String representing the node type and its name.
     */
    public String toString()
    {
        return NodeName;
    }
}

//*****************************************************************************
