//*****************************************************************************
/*
** FILE:   da_ColumnElement.java
**
** (c) 1998 Steve Withall.
**
** HISTORY:
**    24May98  stevew  Created.
*/
package da;

import xg.xg_Element;
import xg.xg_VerificationException;

import eh.eh_Debug;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.lang.StringBuffer;

//*****************************************************************************
/** An XML element to represent the structure of one column in a database
 *  table.
 */
public class da_ColumnElement extends xg_Element
{
    /** The name of this column. */
    protected String           ColumnName           = null;

    /** The element type name normally used in XML for this sort of element. */
    public final static String RegisteredName       = "Column";

    /** The name of the attribute which holds the name of this column. */
    public final static String NameAttName          = "Name";

    /** The name of the attribute which holds the data type of this column (using
     *  one of the values defined in java.sql.Types). */
    public final static String DataTypeAttName      = "DataType";

    /** The name of the attribute which holds the data type name of this column. */
    public final static String DataTypeNameAttName  = "DataTypeName";

    /** The name of the attribute which holds the size of this column. */
    public final static String ColumnSizeAttName    = "Size";

    /** The name of the attribute which holds the number of decimal digits of this
     *  column. */
    public final static String DecimalDigitsAttName = "DecimalDigits";

    //*****************************************************************************
    /** Construct a database column element with no name.
     */
    public da_ColumnElement()
    {
        super(RegisteredName);
    }

    //*****************************************************************************
    /** Construct a database column element with a name.
     *
     *  @param  InputNodeName  The name of the element
     */
    public da_ColumnElement(String InputNodeName)
    {
        super(InputNodeName);
    }

    //*****************************************************************************
    /** <p>Verify that this node is correct (ie. internally correct and/or consistent
     *  with other nodes - such as its parent). The node is OK if it possesses a
     *  'Name' attribute.</p>
     *
     *  @exception  xg_VerificationException  Description of verification problem
     */
    public void verify() throws xg_VerificationException
    {
        eh_Debug.add(8, "da_ColumnElement.verify:");
        ColumnName = getAttributeValue(NameAttName);
        if (ColumnName == null)
            throw new xg_VerificationException("Database column does not contain a '"
                                                   + NameAttName + "' attribute",
                                               getStartOffset(),
                                               getEndOffset() );
    }

    //*****************************************************************************
    /** Analyse the definition of the column whose details are in the
     *  InputColumnResultSet, and model it here.
     *
     *  @param  InputMetaData         the metadata describing the database to which
     *                                 this table belongs
     *  @param  InputColumnResultSet  the result set from which to obtain details
     *                                 about the column we represent
     */
    public void analyseColumn(DatabaseMetaData  InputMetaData,
    	                      ResultSet         InputColumnResultSet)
    {
        try
        {
  	        ColumnName = InputColumnResultSet.getString(4);
  	        addAttribute(NameAttName, ColumnName);
	        eh_Debug.add(6, "da_ColumnElement.analyseColumn: Column '" + ColumnName + "'");

   	        short DataType = InputColumnResultSet.getShort(5);
  	        addAttribute(DataTypeAttName, String.valueOf(DataType) );

   	        String DataTypeName = InputColumnResultSet.getString(6);
  	        addAttribute(DataTypeNameAttName, DataTypeName);

   	        int ColumnSize = InputColumnResultSet.getInt(7);
  	        addAttribute(ColumnSizeAttName, String.valueOf(ColumnSize) );

   	        int DecimalDigits = InputColumnResultSet.getInt(9);
  	        addAttribute(DecimalDigitsAttName, String.valueOf(DecimalDigits) );

  	        //TBD There are other values which could be extracted!
        }
        catch (SQLException InputException)
        {
	        eh_Debug.add(2, "Error retrieving column details: " + InputException);
        }
    }

    //*****************************************************************************
    /** Get a summary descriptive string suitable for display in the tree view or
     *  elsewhere.
     *
     *  @return  A description suitable for display in the tree view
     */
    public String toString()
    {
        return(NodeName + " '" + ColumnName + "'");
    }
}

//*****************************************************************************
