<xsl>
	<!--Stylesheet to demonstrate the dynamic nature of the element
	names and class names used in the xs implementation. In this
	example, French names are registered for the main XSL element
	types, and then used in place of the normal ones. This stylesheet
	is intended for demonstration purposes only, and there is no
	suggestion that anyone would want to do this in practice.-->

	<NodeTypeDefaults ParserClass="xe.xe_ElementParser"
		            CustomizerClass="xc.xc_ElementCustomizer"
		            ViewClass="xv.xv_BoxViewX" />
	<NodeType Name="enfants" Description="XSL children"
                NodeClass="xs.xs_ChildrenElement" />
	<NodeType Name="vide" Description="XSL empty"
                NodeClass="xs.xs_EmptyElement" />
	<NodeType Name="lment" Description="XSL empty"
                NodeClass="xs.xs_ElementElement"
		    CustomizerClass="xs.xs_PatternElementCustomizer" />
	<NodeType Name="lment-objectif" Description="XSL empty"
                NodeClass="xs.xs_TargetElementElement"
		    CustomizerClass="xs.xs_PatternElementCustomizer"  />
	<NodeType Name="regle" Description="XSL rule"
                NodeClass="xs.xs_RuleElement" />
	<NodeType Name="regle-de-style" Description="XSL style rule"
                NodeClass="xs.xs_StyleRuleElement" />
	<NodeType Name="origine" Description="XSL root rule"
                NodeClass="xs.xs_PatternElement" />
	<NodeType Name="evaluer" Description="XSL eval"
                NodeClass="xs.xs_EvalElement" />
	<regle>
		<!-- Pattern -->
		<root/>
		<!-- Action -->
		<HTML>
		<HEAD>
		<TITLE>Database Schema</TITLE>
		</HEAD>
		<BODY>
		<enfants/>
		</BODY>
		</HTML>
	</regle>
	<regle>
		<!-- Pattern -->
		<lment-objectif type = "DatabaseTableName"/>
		<!-- Action -->
		<H1><enfants/> Table</H1>
	</regle>
	<regle>
		<!-- Pattern -->
		<lment-objectif type = "Columns"/>
		<!-- Action -->
		<TABLE BORDER="1">
		<TR>
		<TD>Name</TD>
		<TD>Data type</TD>
		<TD>Data type name</TD>
		<TD>Size</TD>
		<TD>Decimals</TD>
		</TR>
		<enfants/>
		</TABLE>
	</regle>
	<regle>
		<!-- Pattern -->
		<lment-objectif type = "Column"/>
		<!-- Action -->
		<TR>
		<enfants/>
		</TR>
	</regle>
	<regle>
		<!-- Pattern -->
		<lment-objectif type = "ColumnName"/>
		<lment-objectif type = "ColumnDataType"/>
		<lment-objectif type = "ColumnDataTypeName"/>
		<lment-objectif type = "ColumnSize"/>
		<lment-objectif type = "ColumnDecimalDigits"/>
		<!-- Action -->
		<TD><enfants/></TD>
	</regle>
	<regle>
                <lment-objectif type = "Indexes"/>
                <H2>Indexes</H2>
                <enfants/>
	</regle>
	<regle>
                <lment-objectif type = "IndexName"/>
                <H3><enfants/> Index</H3>
	</regle>
	<regle>
                <lment-objectif type = "DatabaseViewName"/>
                <H1><enfants/> View</H1>
	</regle>
	<regle-de-style font-weight="italic" color="green">
		<lment-objectif type = "DatabaseTableName"/>
		<appliquer font-weight="bold" color="red"/>
	</regle-de-style>
	<regle-de-style>
		<lment-objectif type = "Columns"/>
		<appliquer font-weight="italic" color="blue"/>
	</regle-de-style>
</xsl>
