# spec2html.cmd
#
# This package is a non-production quality attempt
# to define a mapping from the W3C XML spec DTD to
# the HTML 4.0 Transitional DTD
#
# Revised 1999 Jan 03 (pbg) -- created
# Revised 1999 Jan 12 (pbg) -- added code in process_oid to toss PIs
#                               and fixed code for suppressed elements
# Revised 1999 Jan 15 (pbg) -- added code to insert <a name=X></a> for
#                       heads with id=X; also code to handle front
# Revised 1999 Feb 10-11 (pbg) -- added code to insert <a name=X></a>
#                       for any tag with id=X and code to insert
#                       <a href=Y> for any tag with def|ref=Y plus
#                       special code to handle constraint, prod, lhs
# Revised 1999 Feb 15 (pbg) -- added code to handle vc, wfc, specref

package spec2html

# Assume an xmlspec doc as the current doc in the edit window.
# Then execute process_header (which starts by creating a new
# html 4.0 skeleton document), then process_front, _body, _back.

function read_xtable() {}
function process_header() {}
function process_front() {}
function process_body() {}
function process_back() {}
function process_oid() {}
function oid_whose_id_is() {}
function oid_of_child_loc() {}
function oid_of_child_head() {}
function process_oid_contents() {}
function expand_entrefs() {}

global prodnum

function xmlspec2html(hfname='',doc=0)
{
        local outbuf, xoid, rc
        local table_fname="c:/myadept/doctypes/xmlspec/packages/spec2html.tbl"

        if (doc == 0) { doc = current_doc() }
        set -local gentext=off showentities=none tabletags=on autotaginserts=off sgmlselection=on
        if (hfname == '')
                {
                local xpath=doc_path(doc)
                local xfname=basename(xpath,".*")
                hfname = dirname(xpath) . xfname . ".htm"
                }

        # see if hfname already exists
        if (access(hfname,"rw"))
                {
                local resp=response("spec2html: file $hfname exists--okay to remove it?",\
                        "OK","Cancel")
                if (resp!=1) { return 1 }
                remove_file "$hfname"
                }
        # create new empty HTML 4.0 Transitional doc
        local fid = open(hfname,"w")
        if (fid < 0)
                {
                message "spec2html: cannot create $hfname"
                return 1
                }

        outbuf  = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">'
        outbuf .= "<html><?Pub Caret></html>"

        put(fid,outbuf)
        close(fid)

        read_xtable(table_fname)

        local hdoc = doc_open(hfname,16)

        prodnum=0

        xoid = process_header(hdoc,doc)
        if (!oid_valid(xoid)) { return 1 }
        current_doc(hdoc)
        # now process the document's front if it has one
        if (oid_name(xoid)=="front")
                {
                rc = process_front(hdoc,xoid)
                if (rc != 0)
                        {
                        current_doc(hdoc); save; current_doc(doc)
                        doc_close(hdoc)
                        return 1
                        }
                }
        if (oid_name(xoid)!="body") { xoid = oid_next(xoid) }
        current_doc(hdoc)
        rc = process_body(hdoc,xoid)
        if (rc != 0)
                {
                current_doc(hdoc); save; current_doc(doc)
                doc_close(hdoc)
                return 1
                }
        # now process the document's back if it has one
        xoid = oid_next(xoid)
        if (oid_valid(xoid))
                {
                current_doc(hdoc)
                return process_back(hdoc,xoid)
                }
        current_doc(hdoc); save; current_doc(doc)
        doc_close(hdoc)
        return

}

function next_xoid(xoid)
{
# set xoid to the first oid following the end of xoid

        local o

        if (oid_valid(oid_next(xoid)))
                {
                return oid_next(xoid)
                }
        else
                {
                o = oid_forward(xoid)
                # while o is inside xoid, oid_forward
                while (oid_level(xoid,o)>0) { o = oid_forward(o) }
                return o
                }
}

function process_header(hdoc,doc)
{
# Process the header.  This requires reading and expanding
# some entity refs and stuff and setting some variables all
# before creating the initial HTML template.

        local outbuf, title, version, w3c_designation, w3c_doctype
        local pdday, pdmonth, pdyear, notice='', xname, xoid

        current_doc(doc)

        xoid = oid_first(doc)
        while (oid_valid(xoid) && (oid_name(xoid)!="publoc"))
                {
                xname = oid_name(xoid)
                switch (xname)
                {
                case "title":
                        title=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "version":
                        version=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "w3c-designation":
                        w3c_designation=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "w3c-doctype":
                        w3c_doctype=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "day":
                        pdday=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "month":
                        pdmonth=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "year":
                        pdyear=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case "notice":
                        # this isn't really right, but it'll work
                        # as long as the only things in the notice
                        # are valid HTML (e.g., <p>'s)
                        notice=expand_entrefs(oid_content(xoid),doc)
                        xoid = next_xoid(xoid)
                        break
                case /publoc|pubdate|spec|header|_comment/:
                        xoid = oid_forward(xoid)
                        break
                default:
                        response("spec2html: in pubinfo, no processing for <$xname>");
                        xoid = oid_forward(xoid)
                }
                if (xname == "publoc") { break }
                }

        outbuf  = "<head><title>$title</title></head>"
        outbuf .= "<body><h3 align='right'><a href='http://www.w3.org/'>"
        outbuf .= "<img src='http://www.w3.org/Icons/WWW/w3c_home'"
        outbuf .= "alt='W3C' align='left' border='0'></a>"
        outbuf .= "$w3c_designation</h3><br clear='all'>"
        outbuf .= "<h1 align='center'>$title<br>$version</h1>"
        outbuf .= "<h4 align='center'>$w3c_designation</h4>"
        outbuf .= "<h3 align='center'>$w3c_doctype</h3>"
        outbuf .= "<h4 align='center'>Current Edition: "
        outbuf .= "$pdyear $pdmonth $pdday</h4>"
        outbuf .= "<!--last revised \$Date: "
        outbuf .= "$pdyear/$pdmonth/$pdday " . '$ by $Author:  $-->'
        if (notice!='')
                { outbuf .= "<blockquote>$notice</blockquote>" }
        outbuf .= "<dl><?Pub Caret></dl>"
        outbuf .= "<hr><p><a href='http://validator.w3.org/'>"
        outbuf .= "<img src='http://validator.w3.org/images/vh40.gif'"
        outbuf .= "alt='Valid HTML 4.0!' height='31' width='88'"
        outbuf .= " border='0'></a></p></body>"

        current_doc(hdoc)
        insert(outbuf)

        # xoid is now the xmlspec document's publoc
        while (oid_valid(xoid) && (oid_name(xoid)!="front") && (oid_name(xoid)!="body"))
                {
                if (process_oid(hdoc,xoid) > 0) { return 1 }
                if (oid_name(xoid) == "authlist")
                        {
                        # jump out of dl in hdoc
                        forward_char(1,hdoc)
                        }
                if (oid_valid(oid_next(xoid)))
                        {
                        xoid = oid_next(xoid)
                        }
                else
                        {
                        # Done with header, find front or body
                        while (oid_valid(xoid) && (oid_name(xoid)!="front") && (oid_name(xoid)!="body"))
                                { xoid = oid_forward(xoid) }
                        }
                }
        # xoid is the xmlspec document's front or body element
        return xoid
}

global counters[], inpart

function process_front(hdoc,xoid)
{
        # xoid is now the xmlspec document's front
        # set up for heads to format for the front
        # then process the front.
        inpart = 'front'
        return process_oid(hdoc,xoid)
}

function process_body(hdoc,xoid)
{
        # xoid is now the xmlspec document's body
        # set up counts for heads to format for the body
        # then process the body.
        for (i=1;i<=6;i++) { counters[i]=0 }
        inpart = 'body'
        return process_oid(hdoc,xoid)
}

function process_back(hdoc,xoid)
{
        # xoid is now the xmlspec document's back element
        # set up counts for heads to format for the back
        # then process the back
        for (i=1;i<=6;i++) { counters[i]=0 }
        inpart = 'back'
        return process_oid(hdoc,xoid)
}

global haveentry[], newtag[], pretext[], posttext[], suppress[]

function read_xtable(table_fname)
{
# This function reads a translation table with lines of the form:
# [parent/]gi;newtag;pretext;posttext;suppress
# to fill a set of global arrays newtag[], pretext[], posttext[],
# and suppress[] that is used to process each oid

        local inbuf, numfields, array[]

        local tid = open(table_fname,"r")
        if (tid == 0)
                {
                message "spec2html: cannot open table file $table_fname"
                return 1
                }

        while (getline(tid, inbuf))
                {
                chop(inbuf)
                if ((trim(inbuf)=='') || (substr(inbuf,1,1)=='#')) { continue };
                numfields = split(inbuf, array, ";")
                if (numfields < 2)
                        {
                        message "spec2html: bad entry in $table_fname"
                        return 1
                        }
                # newtag may be a comma-separated list.  any 'newtag'
                # is a tag name optionally followed by an attribute list.
                # Furthermore, attributes of the 'target' tag (the only
                # or last tag in the first field of each table line) get
                # copied onto the last newtag if it would allow such an
                # attribute (there is currently no way to rename attrs).
                haveentry[array[1]] = 1
                newtag[array[1]] = array[2]
                pretext[array[1]] = array[3]
                posttext[array[1]] = array[4]
                suppress[array[1]] = array[5]
                }

        close(tid)
}

function expand_entrefs(inbuf,xdoc)
{
        local outbuf, str, repl

        if (inbuf=='') { return '' }
        inbuf = inbuf . '&;'
        outbuf = ''
        while (inbuf != '')
                {
                i = index(inbuf,'&')
                outbuf .= substr(inbuf,1,i-1)
                str = substr(inbuf,i)
                i = index(str,';')
                entref = substr(str,1,i-1)
                if ((entref=='&') || (entref=='')) { break }
                if ((entref=='&ldquo')||(entref=='&rdquo'))
                        {
                        repl = '"'
                        }
                else
                        {
                        repl = tag_attr_value(entref,"Text",xdoc)
                        }
                inbuf = expand_entrefs(repl,xdoc) . substr(str,i+1)
                }

        return outbuf
}

function process_oid(hdoc,xoid)
{
# Processing for an oid is as follows--at current location in hdoc:
#   1.  insert newtags (a newtag of * is special--see below)
#   2.  for all attributes on oid, if valid on last newtag, put them there
#   3.  insert pretext
#   4.  if not suppressing, for each pcdata chunk or child element of oid,
#   4a.   if pcdata, insert it
#   4b.   else (child element) call process_oid on it
#   5.  insert posttext
#
# If newtag is *, skip all above an go to section where we do special
# processing based on oid_name.  So far, that consists of:
#   for bibref:
#       bibref's ref attr pts to bibl, take bibl's key attr's value,
#       surround with <a> whose href is expanded value of bibl's
#       child loc's href
#   for ?/head (where ? is any of div{1,2,3,4} or inform-div{1,2,3,4})
#       map it into hN where N is the div#+2 and put pretext equal to
#       the computed compound number based on nested divs (using all
#       arabic in the body and initial alpha in the back)

        local xname, xtag, inbuf, numfields, tags, array[], tag, attrs
        local i, j, hnum_str, xparent, xdoc=oid_doc(xoid), attr
        local text_entity_type_oid=5, pi_type_oid=7

        xtag = oid_name(xoid)
        # first handle text entity oids
        if (oid_type(xoid)==text_entity_type_oid)
                {
                # expand text entity (must add closing ';')
                inbuf = expand_entrefs(xtag.';',xdoc)
                insert(inbuf,hdoc)
                return 0
                }
        else if (oid_type(xoid)==pi_type_oid)
                {
                # skip PI
                return 0
                }

        # get values from table for this element
        # (first trying for a match in the context
        # of its parent, and then just alone)
        xparent = oid_name(oid_parent(xoid))
        xname = xparent . '/' . xtag
        if (haveentry[xname] != 1) { xname = xtag }
        while (haveentry[xname] != 1)
                {
                # no entry for this element
                local default_table_entry="$xname;font class='dne';"
                readvar -prompt "No table entry for <$xname>--supply one:" \
                        -value "$default_table_entry" inbuf
                numfields = split(inbuf, array, ";")
                if (numfields < 2)
                        {
                        local resp=response("spec2html: bad table entry","try again","quit")
                        if (resp != 1) { return 1 }
                        }
                else
                        {
                        haveentry[array[1]] = 1
                        newtag[array[1]] = array[2]
                        pretext[array[1]] = array[3]
                        posttext[array[1]] = array[4]
                        suppress[array[1]] = array[5]
                        }
                }
        tags = newtag[xname]

        current_doc(hdoc)
        local outermost_inserted_oid = oid_null()
        local defval=""

        if (tags != "*")
                {
                # if xoid has an assigned "id" attribute, first insert an <a name=$idval></a>
                if (oid_attr(xoid,"id")!="" && in_context("a"))
                        {
                        insert("<a name=". oid_attr(xoid,"id") ."></a>")
                        }
                # if xoid has an assigned "def|ref" attribute, insert an a tag with href=#$defval
                if (oid_attr(xoid,"def")!="")
                        { defval=oid_attr(xoid,"def") }
                else if (oid_attr(xoid,"ref")!="")
                        { defval=oid_attr(xoid,"ref") }
                if (defval!="" && in_context("a"))
                        {
                        if (oid_name(oid_caret(hdoc))!="a")
                                {
                                insert_tag("a")
                                outermost_inserted_oid = oid_caret(hdoc)
                                }
                        modify_tag -local -caret href="#$defval"
                        }

                # process all new tags
                numfields = split(tags, array, ",")

                for (i=1; i<=numfields; i++)
                        {
                        # pick off newtag attribute specs
                        j = index(array[i],' ')
                        if (j==0) { tag = array[i]; attrs='' }
                        else
                                {
                                tag = substr(array[i],1,j-1)
                                attrs = substr(array[i],j+1)
                                }
                        # insert this new tag
                        if (in_context(tag))
                                {
                                insert_tag(tag)
                                # if this is the first non-empty tag inserted for this xoid,
                                # remember its oid for later position adjustment
                                if (!oid_valid(outermost_inserted_oid))
                                        {
                                        if (tag_content(tag)!="EMPTY")
                                                {
                                                outermost_inserted_oid = oid_caret()
                                                }
                                        }
                                # modify its attributes
                                if (attrs != '') { modify_tag -local -caret $attrs }
                                }
                        else
                                {
                                resp=response("spec2html: cannot insert <$tag>","Continue","Quit")
                                if (resp!=1) { return 1 }
                                }
                        }
                # now try to put xname's attrs onto the last tag
                oid_attr_list(xoid,array)
                for (attr in array)
                        {
                        # if this attr is valid on tag, add it
                        if (tag_has_attr(tag,attr))
                                {
                                local str = attr . '="' . expand_entrefs(array[attr],xdoc) . '"'
                                modify_tag -local -caret $str
                                }
                        }
                # insert pretext
                insert(pretext[xname])
                # if not suppressing, for each pcdata chunk or child element of xoid,
                #   if pcdata, insert it
                #   else (child element) call process_oid on it
                if (tag_content(tag)=="EMPTY")
                        {
                        # do nothing here
                        }
                else if (suppress[xname])
                        {
                        goto_oid(xoid,-1)
                        }
                else
                        {
                        if (process_oid_contents(hdoc,xoid) > 0) { return 1 }
                        }
                # insert posttext
                insert(posttext[xname])
                }
        else
                {
                # here handle special cases
                current_doc(hdoc)
                switch (xname)
                        {
                        case "bibref":
                                # bibref's ref attr pts to bibl, take bibl's key attr's value,
                                # surround with <a> whose href is expanded value of bibl's
                                # child loc's href
                                local ref = oid_attr(xoid,'ref')
                                local bibl_oid = oid_whose_id_is(ref,xdoc)
                                local key = oid_attr(bibl_oid,'key')
                                local loc_oid = oid_of_child_loc(bibl_oid)
                                local href = oid_attr(loc_oid,'href')
                                href = expand_entrefs(href,xdoc)
                                insert("<a href=".'"'.href.'"'.">$key<?Pub Caret></a>")
                                outermost_inserted_oid = oid_caret(hdoc)
                                break
                        case "specref":
                                # specref--generate proper content for <a>
                                # based on referenced object:
                                # 1.  Section #, Title
                                # 2.  item#
                                # 3.  [prod-number]
                                # 4.  Issue id
                                # ??? still need to get the section, item, and prod number
                                local ref = oid_attr(xoid,'ref')
                                local refed_oid = oid_whose_id_is(ref,xdoc)
                                local reftext = "??"
                                switch (oid_name(refed_oid))
                                        {
                                        case /div1|div2|div3|div4|div5/:
                                                reftext = "the section titled "
                                                local head_oid = oid_of_child_head(refed_oid)
                                                local refedhead = oid_content(head_oid)
                                                refedhead = expand_entrefs(refedhead,xdoc)
                                                reftext .= refedhead
                                                break
                                        case "item":
                                                reftext = "the item with id=".oid_attr(refed_oid,"id")
                                                break
                                        case "prod":
                                                reftext = 'Production ['.oid_attr(refed_oid,"id").']'
                                                break
                                        case "issue":
                                                reftext = 'Issue ['.oid_attr(refed_oid,"id").']'
                                                break
                                        }
                                href = expand_entrefs(ref,xdoc)
                                insert("<a href=".'"#'.href.'"'.">$reftext<?Pub Caret></a>")
                                outermost_inserted_oid = oid_caret(hdoc)
                                break
                        case "head":
                                # for $xparent/head (where $xparent is any of div{1,2,3,4}
                                # or inform-div{1,2,3,4}), map it into hN where N is the
                                # div#+2 and put pretext equal to the computed compound
                                # number based on nested divs (using all
                                # arabic in the body and initial alpha in the back)
                                #
                                # if there is an id="X" attribute, generate <a name="X"></a>
                                local div_num = substr(xparent,length(xparent),1) + 2
                                if ((div_num < 3) || (div_num > 6))
                                        { response("spec2html: invalid div num ($div_num) for $xparent/head") }
                                insert_tag("h".div_num,hdoc)
                                outermost_inserted_oid = oid_caret(hdoc)
                                local idval = oid_attr(xoid,"id")
                                if (idval!="")
                                        {
                                        insert('<a name="'.idval.'"></a>')
                                        }
                                # compute division number and insert as pretext (unless in front)
                                if (inpart!='front')
                                        {
                                        counters[div_num] += 1
                                        for (i=div_num+1;i<=6;i++) { counters[i] = 0 }
                                        if (inpart=='back')
                                                {
                                                hnum_str = chr(64+counters[3]) . '.'
                                                }
                                        else
                                                {
                                                hnum_str = counters[3] . '.'
                                                }
                                        for (i=4;i<=div_num;i++)
                                                {
                                                hnum_str .= counters[i] . '.'
                                                }
                                        insert(hnum_str.' ',hdoc)
                                        }
                                # now process the head contents
                                if (process_oid_contents(hdoc,xoid) > 0) { return 1 }
                                break
                        case /constraint|vc|wfc/:
                                # take constraint's def's attribute value and find
                                # the constraintnote whose ID is that value, then
                                # take that constraintnote's head and put
                                # that text surrounded by square brackets in a dd
                                local defval = oid_attr(xoid,"def")
                                local chead
                                switch (xname)
                                        {
                                        case "vc":
                                                chead = "VC: "
                                                break
                                        case "wfc":
                                                chead = "WFC: "
                                        }
                                if (defval!="")
                                        {
                                        # find constraintnote whose ID is $defval
                                        local cnoid=oid_first(xdoc)
                                        while (oid_valid(cnoid))
                                                {
                                                if (oid_attr(cnoid,"id")==defval)
                                                        {
                                                        # set chead
                                                        local o=oid_forward(cnoid)
                                                        if (oid_name(o)=='head')
                                                                {
                                                                chead .= oid_content(o)
                                                                }
                                                        break
                                                        }
                                                cnoid=oid_forward(cnoid)
                                                }
                                        }
                                insert("<dd><?Pub Caret>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".\
                                        "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".\
                                        "<small><a href=\"#$defval\">[$chead]</a></small></dd>")
                                outermost_inserted_oid = oid_caret(hdoc)
                                break
                        case "prod":
                                # must make prod's id the "name" of an "a" tag, then insert dl
                                local idval = oid_attr(xoid,"id")
                                if (idval!="")
                                        {
                                        insert('<a name="'.idval.'"></a>')
                                        }
                                insert("<dl><?Pub Caret></dl>")
                                outermost_inserted_oid = oid_caret(hdoc)
                                # now process the prod contents
                                if (process_oid_contents(hdoc,xoid) > 0) { return 1 }
                                break
                        case "lhs":
                                # need to generate the production number along with markup
                                insert("<dt><?Pub Caret></dt>")
                                outermost_inserted_oid = oid_caret(hdoc)
                                prodnum = prodnum + 1
                                insert("<a><code><strong>[$prodnum] ".\
                                        "<?Pub Caret></strong> ::=</code>")
                                # now process the lhs contents
                                if (process_oid_contents(hdoc,xoid) > 0) { return 1 }
                                break
                        default:
                                resp=response("spec2html: no special case for $xname","Continue","Quit")
                                if (resp != 1) { return 1 }
                        }
                }
        # now position to just after all the newly inserted tags' endtags
        current_doc(hdoc)
        if (oid_valid(outermost_inserted_oid))
                {
                goto_oid(outermost_inserted_oid,-1)
                forward_char(1)
                }
        return 0
}

function process_oid_contents(hdoc,xoid)
{
        local chunk, curoid, xdoc=oid_doc(xoid), text_entity_type_oid=5

        # starting just after xoid's starttag, go to just before
        # next child's starttag
        current_doc(xdoc)
        goto_oid(xoid)
        clear_mark
        mark -noselect -noinvert
        curoid = oid_child(xoid)
        if (!oid_valid(curoid))
                {
                # xoid had no children, just pass through its
                # text content (take care for empty elements)
                if (!oid_empty(xoid))
                        {
                        goto_oid(xoid,-1)
                        mark
                        chunk = main::selection
                        if (chunk != '') { insert(chunk,hdoc) }
                        }
                }
        else
                {
                # xoid has at least one child
                # Loop through all the content of xoid...
                while (oid_valid(curoid))
                        {
                        goto_oid(curoid)
                        forward_char(-1) ;# (stop marking just prior to start of this child)
                        mark
                        # ...passing through runs of #PCDATA and...
                        chunk = main::selection
                        if (chunk != '') { insert(chunk,hdoc) }
                        # ...recursively processing children...
                        if (process_oid(hdoc,curoid) > 0) { return 1 }
                        # ...and then jump to after the child and continue
                        current_doc(xdoc)
                        if ((oid_type(curoid)==text_entity_type_oid) || \
                                        (tag_content(oid_name(curoid),xdoc)=="EMPTY"))
                                {
                                goto_oid(curoid)
                                }
                        else
                                {
                                goto_oid(curoid,-1)
                                forward_char(1)
                                }
                        clear_mark
                        mark -noselect -noinvert
                        curoid = oid_next(curoid)
                        }
                # now handle part of xoid after its last child
                goto_oid(xoid,-1)
                mark
                chunk = main::selection
                if (chunk != '') { insert(chunk,hdoc) }
                }
        current_doc(hdoc)
}

function oids_id(oid)
{
        local attr, array[]

        oid_attr_list(oid, array)
        for (attr in array)
                {
                if (oid_attr_type(oid,attr)=='ID')
                        {
                        return oid_attr(oid,attr)
                        }
                }
        return ''
}

function oid_whose_id_is(idref,doc=0)
{
        local oid

        if (doc==0) { doc=current_doc() }

        oid = oid_first(doc)
        while (oid_valid(oid))
                {
                if (oids_id(oid)==idref) { break }
                oid = oid_forward(oid)
                }
        return oid
}

function oid_of_child_loc(bibloid)
{
        local oid

        for (oid=oid_child(bibloid);oid_valid(oid);oid=oid_next(oid))
                {
                if (oid_name(oid)=='loc') { break }
                }
        return oid
}

function oid_of_child_head(divoid)
{
        local oid

        for (oid=oid_child(divoid);oid_valid(oid);oid=oid_next(oid))
                {
                if (oid_name(oid)=='head') { break }
                }
        return oid
}

alias gen_html spec2html::xmlspec2html()
#if (!cmd_exists('soit')) {
#       execute alias soit {source c:/pbg/packages/spec2html.cmd}
#}