<?xml version="1.0" encoding="UTF-8"?> 
<!-- Copyright 1998-2004 W3C (MIT, ERCIM, Keio), All Rights Reserved. -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ssml="http://www.w3.org/2001/10/synthesis"
                xmlns:conf="http://www.w3.org/2002/ssml-conformance"
                xmlns="http://www.w3.org/2001/10/synthesis"
                exclude-result-prefixes="ssml conf">                
                            
<!-- ################### -->
<!-- P a r a m e t e r s -->
<!-- ################### -->
<xsl:param name="mode" select="'test'"/> <!-- 'instruction', 'reference', or 'test' -->

<!-- ################ -->
<!-- T o p  L e v e l -->
<!-- ################ -->
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>

<xsl:template match="/"> 
    <xsl:choose>
        <xsl:when test="$mode = 'instruction'">
            <xsl:apply-templates select="//conf:instruction"/>  
        </xsl:when>
        <xsl:when test="$mode = 'reference'">
            <xsl:apply-templates select="//conf:reference_markup"/>            
            
            <!-- For consistency, always return a valid SSML document -->
            <xsl:if test="count(//conf:reference_markup) = 0">
                <speak version="1.0">
                    <xsl:call-template name="meta"/>  
                </speak>
            </xsl:if>
        </xsl:when>
        <xsl:when test="$mode = 'test'">
            <xsl:apply-templates select="//conf:test_markup"/>
        </xsl:when>
        <xsl:otherwise>
            Error - unknown mode type: <xsl:value-of select="$mode"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template> 

<!-- ##################### -->
<!-- I n s t r u c t i o n -->
<!-- ##################### -->
<xsl:template match="conf:instruction">
    <speak version="1.0" xml:lang="en-US">
        <xsl:value-of select="."/>
    </speak> 
</xsl:template>

<!-- #################  -->
<!-- R e f e r e n c e  -->
<!-- #################  -->
<xsl:template match="conf:reference_markup">
    <xsl:choose>
        <xsl:when test="0 = count(child::*)">
            <speak version="1.0">
                <xsl:apply-templates select="//conf:test_markup/ssml:speak/@xml:lang"/>
                <xsl:call-template name="meta"/> 
                <xsl:value-of select="normalize-space(//conf:test_markup/ssml:speak)"/>                
            </speak>
        </xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="copy_speak"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- ################ -->
<!-- T e s t  S S M L -->
<!-- ################ -->
<xsl:template match="conf:test_markup">
    <xsl:call-template name="copy_speak"/> 
</xsl:template> 

<!-- ############################## -->
<!-- H e l p e r  T e m p l a t e s -->
<!-- ############################## -->
<!-- Copy the speak element -->
<xsl:template name="copy_speak">   
          <xsl:element name="speak">
                  <xsl:apply-templates select="ssml:speak/@*"/>
                  <xsl:call-template name="meta"/> 
                  <xsl:apply-templates select="ssml:speak/node()"/>
          </xsl:element>
</xsl:template>

<!-- Do copy without the namespace information duplicated -->
<xsl:template match="*">
        <xsl:element name="{name()}"><xsl:apply-templates select="@* | node()"/></xsl:element>
</xsl:template>
<xsl:template match="@*">
        <xsl:attribute name="{name()}">
                <xsl:value-of select="."/>
        </xsl:attribute>
</xsl:template>
<xsl:template match="text()">
        <xsl:value-of select="."/>
</xsl:template>

<!-- Meta data -->
<xsl:template name="meta">    
    <metadata>
        <rdf:RDF xmlns:rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                 xmlns:rdfs = "http://www.w3.org/TR/1999/PR-rdf-schema-19990303#"
                 xmlns:dc = "http://purl.org/metadata/dublin_core#">
            <xsl:element name="rdf:Description">
                <xsl:attribute name="dc:Description">
                    <xsl:copy-of select="normalize-space(//conf:instruction)"/>
                </xsl:attribute>
            </xsl:element> 
        </rdf:RDF>
    </metadata>
</xsl:template>

</xsl:stylesheet> 

