/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.validation;

import org.w3c.dom.Node;
import org.w3c.dom.Range;
import org.w3c.dom.NameList;

/**
 * This interface extends the <code>Range</code> interface with additional 
 * methods for guided document editing. 
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Val-20030205'>Document Object Model (DOM) Level 3 Validation Specification</a>.
 */
public interface RangeVAL extends Range {
    /**
     * Determines if a passed-in node can be "surrounded" by two other nodes. 
     * For example, this convenience method can: 1) get all children of "x", 
     * 2) get all possible parents of "y", and then 3) check if the 
     * passed-in node "b" is present in both sets.
     * @param node1 First node to "surround" passed-in node "b".
     * @param node2 Second node to "surround" passed-in node "b".
     * @param b Node to be "surrounded" by.
     * @return <code>true</code> if it is; <code>false</code> if it is not.
     */
    public boolean canSurroundContents(Node node1, 
                                       Node node2, 
                                       Node b);

    /**
     * Returns a list of names of alternative elements, given a reference 
     * child as a parameter. 
     * @param refChild Reference child.
     * @return A list of names of alternative elements. 
     */
    public NameList getAlternativeElements(Node refChild);

}
