/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.validation;

/**
 *  The Validation operations may throw a <code>ExceptionVAL</code> as 
 * described in their descriptions. 
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Val-20030205'>Document Object Model (DOM) Level 3 Validation Specification</a>.
 */
public class ExceptionVAL extends RuntimeException {
    public ExceptionVAL(short code, String message) {
       super(message);
       this.code = code;
    }
    public short   code;
    // ExceptionVALCode
    /**
     *  If the <code>DocumentEditVAL</code> related to the node does not have 
     * any grammar and <code>wfValidityCheckLevel</code> is set to 
     * <code>PARTIAL</code> or <code>STRICT_VALIDITY_CHECK</code>. 
     */
    public static final short NO_GRAMMAR_AVAILABLE_ERR  = 71;

}
