/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.validation;

import org.w3c.dom.NameList;

/**
 * This interface extends the <code>NodeEditVAL</code> interface with 
 * additional methods for document editing. An object implementing this 
 * interface must also implement the <code>Document</code> interface.
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Val-20030205'>Document Object Model (DOM) Level 3 Validation Specification</a>.
 */
public interface DocumentEditVAL extends NodeEditVAL {
    /**
     * An attribute specifying whether continuous checking for the validity of 
     * the document is enforced or not. Setting this to <code>true</code> 
     * will result in an exception being thrown, i.e., 
     * <code>VALIDATION_ERR</code>, for documents that are invalid at the 
     * time of the call. When set to true, the implementation if free to 
     * raise the <code>VALIDATION_ERR</code> exception on DOM operations 
     * that would make the document invalid with respect to "partial 
     * validity." If the document is invalid, then this attribute will 
     * remain <code>false</code>. This attribute is <code>false</code> by 
     * default.
     */
    public boolean getContinuousValidityChecking();
    /**
     * An attribute specifying whether continuous checking for the validity of 
     * the document is enforced or not. Setting this to <code>true</code> 
     * will result in an exception being thrown, i.e., 
     * <code>VALIDATION_ERR</code>, for documents that are invalid at the 
     * time of the call. When set to true, the implementation if free to 
     * raise the <code>VALIDATION_ERR</code> exception on DOM operations 
     * that would make the document invalid with respect to "partial 
     * validity." If the document is invalid, then this attribute will 
     * remain <code>false</code>. This attribute is <code>false</code> by 
     * default.
     */
    public void setContinuousValidityChecking(boolean continuousValidityChecking);

    /**
     * Returns list of all element node names belonging to the element's 
     * namespace. Given the names, nodes can be created from them; note that 
     * these are not nodes from the instance document, but rather are new 
     * nodes that could be inserted in the document. 
     * @param namespaceURI <code>namespaceURI</code> of namespace. For DTDs, 
     *   this is NULL.
     * @return List of all element node names belonging to the element's 
     *   namespace. 
     */
    public NameList getDefinedElementTypes(String namespaceURI);

    /**
     * Validates the document against the grammar. If the document is mutated 
     * during validation, a warning will be issued. In addition, the 
     * validation cannot modify the document, e.g., for default attributes. 
     * This method makes use of the passed-in error handler, as described in [<a href='http://www.w3.org/TR/2002/WD-DOM-Level-3-Core-20021022'>DOM Level 3 Core</a>]
     *  interface. 
     * @exception ExceptionVAL
     *   NO_GRAMMAR_AVAILABLE_ERR: Raised if an error occurs when the grammar 
     *   is not available for the document.
     */
    public void validateDocument()
                                 throws ExceptionVAL;

}
