/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.validation;

/**
 * This interface extends the <code>NodeEditVAL</code> interface with 
 * additional methods for document editing. An object implementing this 
 * interface must also implement <code>CharacterData</code> interface.
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Val-20030205'>Document Object Model (DOM) Level 3 Validation Specification</a>.
 */
public interface CharacterDataEditVAL extends NodeEditVAL {
    /**
     * <code>true</code> if content only whitespace; <code>false</code> for 
     * non-whitespace.
     */
    public boolean getIsWhitespaceOnly();

    /**
     * Determines if data can be set.
     * @param arg Argument to be set.
     * @return <code>true</code> if no reason it can't be done; 
     *   <code>false</code> if it can't be done.
     */
    public boolean canSetData(String arg);

    /**
     * Determines if data can be appended.
     * @param arg Data to be appended.
     * @return <code>true</code> if no reason it can't be done; 
     *   <code>false</code> if it can't be done.
     */
    public boolean canAppendData(String arg);

    /**
     * Determines if data can be replaced.
     * @param offset Offset.
     * @param count Replacement.
     * @param arg Argument to be set.
     * @return <code>true</code> if no reason it can't be done; 
     *   <code>false</code> if it can't be done.
     */
    public boolean canReplaceData(int offset, 
                                  int count, 
                                  String arg);

    /**
     * Determines if data can be inserted.
     * @param offset Offset.
     * @param arg Argument to be set.
     * @return <code>true</code> if no reason it can't be done; 
     *   <code>false</code> if it can't be done.
     */
    public boolean canInsertData(int offset, 
                                 String arg);

    /**
     * Determines if data can be deleted.
     * @param offset Offset.
     * @param count Number of 16-bit units to delete.
     * @return <code>true</code> if no reason it can't be done; 
     *   <code>false</code> if it can't be done.
     */
    public boolean canDeleteData(int offset, 
                                 int count);

}
