/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.events;

import org.w3c.dom.views.AbstractView;

/**
 * The <code>TextEvent</code> interface provides specific contextual 
 * information associated with Text Events. 
 * <p ><b>Note:</b>  To create an instance of the <code>TextEvent</code> 
 * interface, use the feature string "TextEvent" as the value of the input 
 * parameter used with the <code>DocumentEvent.createEvent</code> method.  
 * In the past, detail was used to contain the repeat count for the key. Do 
 * we want to keep this notion? How? using an auto-repeat event instead? Use 
 * cases? closed. same question for visibleOutputGenerated: This attribute 
 * is device dependent (display related). What happen on voice system for 
 * example? What are the real use cases for it? closed. What happens on 
 * paste through Ctrl-V? Do you get a textInput event or not if the 
 * selection contains characters?  This will be undefined by this 
 * specification. 
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface TextEvent extends UIEvent {
    /**
     *  <code>data</code> holds the value of the characters generated by the 
     * character device. This may be a single Unicode character or it may be 
     * a string. 
     */
    public String getData();

    /**
     * The <code>initTextEvent</code> method is used to initialize the value 
     * of a <code>TextEvent</code> created using the 
     * <code>DocumentEvent.createEvent</code> method. This method may only 
     * be called before the <code>TextEvent</code> has been dispatched via 
     * the <code>EventTarget.dispatchEvent</code> method, though it may be 
     * called multiple times during that phase if necessary. If called 
     * multiple times, the final invocation takes precedence. This method 
     * has no effect if called after the event has been dispatched.
     * @param typeArg Specifies the event type.
     * @param canBubbleArg Specifies whether or not the event can bubble. 
     *   This parameter overrides the intrinsic bubbling behavior of the 
     *   event.
     * @param cancelableArg Specifies whether or not the event's default 
     *   action can be prevent. This parameter overrides the intrinsic 
     *   cancelable behavior of the event.
     * @param viewArg Specifies the <code>TextEvent</code>'s view.
     * @param dataArg Specifies the <code>TextEvent</code>'s <code>data</code>
     *    attribute
     */
    public void initTextEvent(String typeArg, 
                              boolean canBubbleArg, 
                              boolean cancelableArg, 
                              AbstractView viewArg, 
                              String dataArg);

    /**
     * The <code>initTextEventNS</code> method is used to initialize the value 
     * of a <code>TextEvent</code> created using the 
     * <code>DocumentEvent.createEvent</code> method. This method may only 
     * be called before the <code>TextEvent</code> has been dispatched via 
     * the <code>EventTarget.dispatchEvent</code> method, though it may be 
     * called multiple times during that phase if necessary. If called 
     * multiple times, the final invocation takes precedence. This method 
     * has no effect if called after the event has been dispatched.
     * @param namespaceURI  Specifies the namespace URI associated with this 
     *   event, or <code>null</code> if the applications wish to have no 
     *   namespace. 
     * @param type  Specifies the event type. 
     * @param canBubbleArg Specifies whether or not the event can bubble.
     * @param cancelableArg Specifies whether or not the event's default 
     *   action can be prevent.
     * @param viewArg Specifies the <code>TextEvent</code>'s view.
     * @param dataArg Specifies the <code>TextEvent</code>'s <code>data</code>
     *    attribute
     */
    public void initTextEventNS(String namespaceURI, 
                                String type, 
                                boolean canBubbleArg, 
                                boolean cancelableArg, 
                                AbstractView viewArg, 
                                String dataArg);

}
