/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.events;

import org.w3c.dom.Node;

/**
 *  The <code>MutationNameEvent</code> interface provides specific contextual 
 * information associated with Mutation name event types.  To create an 
 * instance of the <code>MutationNameEvent</code> interface, use the feature 
 * string "MutationNameEvent" as the value of the input parameter used with 
 * the <code>createEvent</code> method of the <code>DocumentEvent</code> 
 * interface. 
 * <p>See also the <a href='http://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030221'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface MutationNameEvent extends MutationEvent {
    /**
     *  The previous value of the <code>relatedNode</code>'s 
     * <code>namespaceURI</code>. 
     */
    public String getPrevNamespaceURI();

    /**
     *  The previous value of the <code>relatedNode</code>'s 
     * <code>nodeName</code>. 
     */
    public String getPrevNodeName();

    /**
     *  The <code>initMutationNameEvent</code> method is used to initialize 
     * the value of a <code>MutationNameEvent</code> created using the 
     * <code>DocumentEvent.createEvent</code> method. This method may only 
     * be called before the <code>MutationNameEvent</code> has been 
     * dispatched via the <code>EventTarget.dispatchEvent</code> method, 
     * though it may be called multiple times during that phase if 
     * necessary. If called multiple times, the final invocation takes 
     * precedence. 
     * @param typeArg  Specifies the event type. 
     * @param canBubbleArg Specifies whether or not the event can bubble.
     * @param cancelableArg Specifies whether or not the event's default 
     *   action can be prevented.
     * @param relatedNodeArg Specifies the <code>Event</code>'s related 
     *   <code>Node</code>.
     * @param prevNamespaceURI Specifies the previous 
     *   <code>namespaceURI</code> of the related <code>Node</code>. This 
     *   value may be null.
     * @param prevNodeName Specifies the previous <code>nodeName</code> of 
     *   the related <code>Node</code>.
     * @since DOM Level 3
     */
    public void initMutationNameEvent(String typeArg, 
                                      boolean canBubbleArg, 
                                      boolean cancelableArg, 
                                      Node relatedNodeArg, 
                                      String prevNamespaceURI, 
                                      String prevNodeName);

    /**
     *  The <code>initMutationNameEventNS</code> method is used to initialize 
     * the value of a <code>MutationNameEvent</code> created using the 
     * <code>DocumentEvent.createEvent</code> method. This method may only 
     * be called before the <code>MutationNameEvent</code> has been 
     * dispatched via the <code>EventTarget.dispatchEvent</code> method, 
     * though it may be called multiple times during that phase if 
     * necessary. If called multiple times, the final invocation takes 
     * precedence. 
     * @param namespaceURI  Specifies the namespace URI associated with this 
     *   event, or <code>null</code> if the application wish to have no 
     *   namespace. 
     * @param typeArg  Specifies the event type. 
     * @param canBubbleArg Specifies whether or not the event can bubble.
     * @param cancelableArg Specifies whether or not the event's default 
     *   action can be prevented.
     * @param relatedNodeArg Specifies the <code>Event</code>'s related 
     *   <code>Node</code>.
     * @param prevNamespaceURI Specifies the previous 
     *   <code>namespaceURI</code> of the related <code>Node</code>. This 
     *   value may be null.
     * @param prevNodeName Specifies the previous <code>nodeName</code> of 
     *   the related <code>Node</code>.
     * @since DOM Level 3
     */
    public void initMutationNameEventNS(String namespaceURI, 
                                        String typeArg, 
                                        boolean canBubbleArg, 
                                        boolean cancelableArg, 
                                        Node relatedNodeArg, 
                                        String prevNamespaceURI, 
                                        String prevNodeName);

}
